/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import org.jemmy.Dimension;
import org.jemmy.image.pixel.AverageDistanceComparator;
import org.jemmy.image.pixel.PixelImageComparator;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.ThresholdComparator;

public class MaxDistanceComparator
extends ThresholdComparator {
    public MaxDistanceComparator(double threshold) {
        super(0.0, Math.sqrt(3.0));
        this.setThreshold(threshold);
    }

    public boolean compare(Raster image1, Raster image2) {
        Dimension size = PixelImageComparator.computeDiffSize(image1, image2);
        if (size == null) {
            return false;
        }
        double[] colors1 = new double[image1.getSupported().length];
        double[] colors2 = new double[image2.getSupported().length];
        double distance = 0.0;
        for (int x = 0; x < size.width; ++x) {
            for (int y = 0; y < size.height; ++y) {
                image1.getColors(x, y, colors1);
                image2.getColors(x, y, colors2);
                distance = Math.max(distance, AverageDistanceComparator.distance(image1.getSupported(), colors1, image2.getSupported(), colors2));
            }
        }
        return distance <= this.getThreshold();
    }

    public String getID() {
        return MaxDistanceComparator.class.getName() + ":" + this.getThreshold();
    }
}

