/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import org.jemmy.interfaces.Caret;
import org.jemmy.interfaces.CaretOwner;

public abstract class AbstractCaretOwner
implements CaretOwner {
    private double error;

    public double allowedError() {
        return this.error;
    }

    public void allowError(double error) {
        if (error < 0.0) {
            throw new IllegalArgumentException("Precision could not be less than 0");
        }
        this.error = error;
    }

    public void to(double position) {
        this.caret().to(new ToPosition(this, position, this.error));
    }

    public static class ToPosition
    implements Caret.Direction {
        private double error;
        private double value;
        private CaretOwner caret;

        public ToPosition(CaretOwner caret, double value, double allowedError) {
            this.caret = caret;
            this.value = value;
            this.error = allowedError;
        }

        public ToPosition(CaretOwner caret, double value) {
            this(caret, value, 0.0);
        }

        public int to() {
            double diff = this.diff();
            return Math.abs(diff) <= this.error ? 0 : (diff > 0.0 ? 1 : -1);
        }

        public String toString() {
            return "value == " + this.position() + " with " + this.error + " error";
        }

        protected double diff() {
            return this.position() - this.caret.position();
        }

        public CaretOwner getCaret() {
            return this.caret;
        }

        protected double position() {
            return this.value;
        }
    }
}

