/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import java.util.ArrayList;
import org.jemmy.Point;
import org.jemmy.action.Action;
import org.jemmy.control.Wrap;
import org.jemmy.env.Environment;
import org.jemmy.env.Timeout;
import org.jemmy.interfaces.Caret;
import org.jemmy.interfaces.CaretOwner;
import org.jemmy.interfaces.Focusable;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Mouse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaretImpl
implements Caret {
    public static final Timeout SCROLL_TIMEOUT = new Timeout("ScrollerImpl.scroll", 1L);
    private Wrap<?> wrap;
    private CaretOwner caretOwner;
    private ArrayList<ScrollAction> actions;

    public CaretImpl(Wrap<?> wrap, CaretOwner caretOwner) {
        this.wrap = wrap;
        this.caretOwner = caretOwner;
        this.actions = new ArrayList();
    }

    public Wrap<?> getWrap() {
        return this.wrap;
    }

    protected void addScrollAction(ScrollAction action) {
        this.actions.add(0, action);
    }

    @Override
    public void to(double value) {
        this.to(new DirectionToPosition(this.caretOwner, value));
    }

    @Override
    public void to(final Caret.Direction direction) {
        this.wrap.getEnvironment().getExecutor().execute(this.wrap.getEnvironment(), false, new Action(){

            public void run(Object ... parameters) {
                int orig;
                if (direction.to() == 0) {
                    return;
                }
                if (CaretImpl.this.wrap.is(Focusable.class)) {
                    CaretImpl.this.wrap.as(Focusable.class).focuser().focus();
                }
                if ((orig = direction.to()) == 0) {
                    return;
                }
                double prevPos = CaretImpl.this.caretOwner.position();
                double prevDist = Double.MAX_VALUE;
                for (int i = 0; i < CaretImpl.this.actions.size(); ++i) {
                    while (!this.isInterrupted() && direction.to() * orig >= 0) {
                        ((ScrollAction)CaretImpl.this.actions.get(i)).scrollTo(orig);
                        CaretImpl.this.wrap.getEnvironment().getTimeout(SCROLL_TIMEOUT).sleep();
                        if (CaretImpl.this.caretOwner.position() == prevPos && i < CaretImpl.this.actions.size() - 1) break;
                        prevPos = CaretImpl.this.caretOwner.position();
                        if (direction.to() != 0) continue;
                        return;
                    }
                    orig = direction.to();
                }
            }

            public String toString() {
                return "Scrolling to " + direction.toString() + " condition";
            }
        }, new Object[0]);
    }

    static {
        Environment.getEnvironment().initTimeout(SCROLL_TIMEOUT);
    }

    protected class KeyboardScrollAction
    implements ScrollAction {
        Keyboard.KeyboardButton down;
        Keyboard.KeyboardButton up;
        Keyboard.KeyboardModifier[] downMods;
        Keyboard.KeyboardModifier[] upMods;

        public KeyboardScrollAction(Keyboard.KeyboardButton down, Keyboard.KeyboardModifier[] downMods, Keyboard.KeyboardButton up, Keyboard.KeyboardModifier[] upMods) {
            this.down = down;
            this.up = up;
            this.downMods = downMods;
            this.upMods = upMods;
        }

        public KeyboardScrollAction(Keyboard.KeyboardButton down, Keyboard.KeyboardButton up) {
            this(down, new Keyboard.KeyboardModifier[0], up, new Keyboard.KeyboardModifier[0]);
        }

        public void scrollTo(int direction) {
            CaretImpl.this.wrap.keyboard().pushKey(direction > 0 ? this.up : this.down, direction > 0 ? this.upMods : this.downMods);
        }
    }

    protected class MouseScrollAction
    implements ScrollAction {
        Point up;
        Point down;
        Keyboard.KeyboardModifier[] upMods;
        Keyboard.KeyboardModifier[] downMods;

        public MouseScrollAction(Point down, Keyboard.KeyboardModifier[] downMods, Point up, Keyboard.KeyboardModifier[] upMods) {
            this.up = up;
            this.down = down;
            this.upMods = upMods;
            this.downMods = downMods;
        }

        public MouseScrollAction(Point down, Point up) {
            this(up, new Keyboard.KeyboardModifier[0], up, new Keyboard.KeyboardModifier[0]);
        }

        public void scrollTo(int direction) {
            CaretImpl.this.wrap.mouse().click(1, direction > 0 ? this.up : this.down, Mouse.MouseButtons.BUTTON1, direction > 0 ? this.upMods : this.downMods);
        }
    }

    protected static interface ScrollAction {
        public void scrollTo(int var1);
    }

    public static class DirectionToPosition
    implements Caret.Direction {
        private double value;
        private CaretOwner caret;
        private double precision;

        public DirectionToPosition(CaretOwner caret, double value, double precision) {
            this.value = value;
            this.caret = caret;
            this.precision = precision;
        }

        public DirectionToPosition(CaretOwner caret, double value) {
            this(caret, value, 0.0);
        }

        public int to() {
            double diff = this.position() - this.caret.position();
            return diff == 0.0 ? 0 : (diff > 0.0 ? 1 : -1);
        }

        public String toString() {
            return "value == " + this.position();
        }

        protected double position() {
            return this.value;
        }
    }
}

