/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jemmy.input.CharBindingMap;
import org.jemmy.interfaces.Keyboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCharBindingMap
implements CharBindingMap<Keyboard.KeyboardButton, Keyboard.KeyboardModifier> {
    private Hashtable<Character, CharKey> chars;

    public DefaultCharBindingMap() {
        this.initMap();
    }

    @Override
    public Keyboard.KeyboardButton getCharKey(char c) {
        CharKey charKey = this.chars.get(new Character(c));
        if (charKey != null) {
            return charKey.key;
        }
        return null;
    }

    public Keyboard.KeyboardModifier[] getCharModifiers(char c) {
        CharKey charKey = this.chars.get(new Character(c));
        if (charKey != null) {
            return charKey.modifiers;
        }
        return null;
    }

    public char[] getSupportedChars() {
        char[] charArray = new char[this.chars.size()];
        Enumeration<Character> keys = this.chars.keys();
        int index = 0;
        while (keys.hasMoreElements()) {
            charArray[index] = keys.nextElement().charValue();
        }
        return charArray;
    }

    public void removeChar(char c) {
        this.chars.remove(new Character(c));
    }

    public void addChar(char c, Keyboard.KeyboardButton key, Keyboard.KeyboardModifier ... modifiers) {
        this.chars.put(new Character(c), new CharKey(key, modifiers));
    }

    private void initMap() {
        this.chars = new Hashtable();
        Keyboard.KeyboardButtons[] buttons = Keyboard.KeyboardButtons.values();
        for (int i = 0; i < buttons.length; ++i) {
            String letter;
            String name = buttons[i].name();
            if (name.length() == 1 && Character.isLetter(name.charAt(0))) {
                letter = name;
            } else {
                if (name.length() != 2 || !name.startsWith("D") || !Character.isDigit(name.charAt(1))) continue;
                letter = name.substring(1);
            }
            this.addChar(letter.toLowerCase().charAt(0), buttons[i], new Keyboard.KeyboardModifier[0]);
            if (letter.toUpperCase().equals(letter.toLowerCase())) continue;
            this.addChar(letter.toUpperCase().charAt(0), buttons[i], Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        }
        this.addChar('\t', Keyboard.KeyboardButtons.TAB, new Keyboard.KeyboardModifier[0]);
        this.addChar(' ', Keyboard.KeyboardButtons.SPACE, new Keyboard.KeyboardModifier[0]);
        this.addChar('!', Keyboard.KeyboardButtons.D1, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('\"', Keyboard.KeyboardButtons.QUOTE, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('#', Keyboard.KeyboardButtons.D3, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('$', Keyboard.KeyboardButtons.D4, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('%', Keyboard.KeyboardButtons.D5, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('&', Keyboard.KeyboardButtons.D7, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('\'', Keyboard.KeyboardButtons.QUOTE, new Keyboard.KeyboardModifier[0]);
        this.addChar('(', Keyboard.KeyboardButtons.D9, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar(')', Keyboard.KeyboardButtons.D0, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('*', Keyboard.KeyboardButtons.D8, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('+', Keyboard.KeyboardButtons.EQUALS, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar(',', Keyboard.KeyboardButtons.COMMA, new Keyboard.KeyboardModifier[0]);
        this.addChar('-', Keyboard.KeyboardButtons.MINUS, new Keyboard.KeyboardModifier[0]);
        this.addChar('.', Keyboard.KeyboardButtons.PERIOD, new Keyboard.KeyboardModifier[0]);
        this.addChar('/', Keyboard.KeyboardButtons.SLASH, new Keyboard.KeyboardModifier[0]);
        this.addChar(':', Keyboard.KeyboardButtons.SEMICOLON, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar(';', Keyboard.KeyboardButtons.SEMICOLON, new Keyboard.KeyboardModifier[0]);
        this.addChar('<', Keyboard.KeyboardButtons.COMMA, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('=', Keyboard.KeyboardButtons.EQUALS, new Keyboard.KeyboardModifier[0]);
        this.addChar('>', Keyboard.KeyboardButtons.PERIOD, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('?', Keyboard.KeyboardButtons.SLASH, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('@', Keyboard.KeyboardButtons.D2, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('[', Keyboard.KeyboardButtons.OPEN_BRACKET, new Keyboard.KeyboardModifier[0]);
        this.addChar('\\', Keyboard.KeyboardButtons.BACK_SLASH, new Keyboard.KeyboardModifier[0]);
        this.addChar(']', Keyboard.KeyboardButtons.CLOSE_BRACKET, new Keyboard.KeyboardModifier[0]);
        this.addChar('^', Keyboard.KeyboardButtons.D6, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('_', Keyboard.KeyboardButtons.MINUS, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('`', Keyboard.KeyboardButtons.BACK_QUOTE, new Keyboard.KeyboardModifier[0]);
        this.addChar('{', Keyboard.KeyboardButtons.OPEN_BRACKET, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('|', Keyboard.KeyboardButtons.BACK_SLASH, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('}', Keyboard.KeyboardButtons.CLOSE_BRACKET, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('~', Keyboard.KeyboardButtons.BACK_QUOTE, Keyboard.KeyboardModifiers.SHIFT_DOWN_MASK);
        this.addChar('\n', Keyboard.KeyboardButtons.ENTER, new Keyboard.KeyboardModifier[0]);
    }

    private static class CharKey {
        public Keyboard.KeyboardButton key;
        public Keyboard.KeyboardModifier[] modifiers;

        public CharKey(Keyboard.KeyboardButton key, Keyboard.KeyboardModifier ... modifiers) {
            this.key = key;
            this.modifiers = modifiers;
        }
    }
}

