/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jemmy.JemmyException;
import org.jemmy.input.CaretImpl;
import org.jemmy.interfaces.CaretOwner;
import org.jemmy.interfaces.Text;

public class RegexCaretDirection
extends CaretImpl.DirectionToPosition {
    public static final String REGEX_FLAGS = "";
    String regex;
    boolean front;
    int index;
    Text text;
    int flags;

    public RegexCaretDirection(Text text, CaretOwner caretOwner, String regex, int flags, boolean front, int index) {
        super(caretOwner, 0.0);
        this.text = text;
        this.regex = regex;
        this.flags = flags;
        this.front = front;
        this.index = index;
        if (index < 0) {
            throw new JemmyException("Index must be >=0 but is " + index, regex);
        }
    }

    protected double position() {
        return RegexCaretDirection.position(this.text, this.regex, this.flags, this.front, this.index);
    }

    public static int position(Text text, String regex, int flags, boolean front, int index) {
        Matcher matcher = Pattern.compile(regex, flags).matcher(text.text());
        for (int i = 0; i <= index; ++i) {
            if (matcher.find()) continue;
            throw new JemmyException(index + "'s occurance of \"" + regex + "\" not found.", text);
        }
        return front ? matcher.start() : matcher.end();
    }
}

