/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import org.jemmy.Point;
import org.jemmy.Rectangle;
import org.jemmy.control.Wrap;
import org.jemmy.env.Timeout;
import org.jemmy.input.CaretImpl;
import org.jemmy.interfaces.Caret;
import org.jemmy.interfaces.CaretOwner;
import org.jemmy.interfaces.Scroll;
import org.jemmy.interfaces.Scroller;

public abstract class ScrollerImpl
extends CaretImpl
implements Scroller {
    public static final Timeout SCROLL_TIMEOUT = CaretImpl.SCROLL_TIMEOUT;
    Scroll scroll;

    public ScrollerImpl(Wrap target, CaretOwner caret) {
        super(target, caret);
        this.scroll = new CaretScroll(caret);
        this.addScrollAction(new CaretImpl.ScrollAction(){

            public void scrollTo(int direction) {
                ScrollerImpl.this.getWrap().mouse().click(1, ScrollerImpl.this.getScrollClickPoint(direction > 0));
            }
        });
    }

    protected abstract Point getScrollClickPoint(boolean var1);

    public static Point createScrollPoint(Wrap c, boolean horizontal, boolean increase, int offset) {
        return ScrollerImpl.createScrollPoint(c.getScreenBounds(), horizontal, increase, offset);
    }

    public static Point createScrollPoint(Rectangle bounds, boolean horizontal, boolean increase, int offset) {
        if (horizontal) {
            return new Point(increase ? bounds.width - 1 - offset : offset, bounds.height / 2);
        }
        return new Point(bounds.width / 2, increase ? bounds.height - 1 - offset : offset);
    }

    public void scrollTo(double value) {
        this.to(value);
    }

    public void scrollTo(Scroller.ScrollCondition condition) {
        this.to(new ConditionDirection(condition, this.scroll));
    }

    public static class CaretScroll
    implements Scroll {
        CaretOwner co;

        public CaretScroll(CaretOwner co) {
            this.co = co;
        }

        public double maximum() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double minimum() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double value() {
            return this.co.position();
        }

        public Scroller scroller() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double position() {
            return this.co.position();
        }

        public Caret caret() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void to(double position) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class ConditionDirection
    implements Caret.Direction {
        Scroller.ScrollCondition condition;
        Scroll scroll;

        public ConditionDirection(Scroller.ScrollCondition condition, Scroll scroll) {
            this.condition = condition;
            this.scroll = scroll;
        }

        public int to() {
            return this.condition.scrollToward(this.scroll);
        }
    }
}

