/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input;

import org.jemmy.Dimension;
import org.jemmy.Point;
import org.jemmy.control.Wrap;
import org.jemmy.interfaces.Window;

public class WindowImpl
implements Window {
    private Wrap control;
    private int offset;

    public WindowImpl(Wrap control, int offset) {
        this.control = control;
        this.offset = offset;
    }

    public void move(Point dest) {
        Point start = this.control.getClickPoint();
        Point target = new Point(start.x + dest.x, start.y + dest.y);
        this.control.drag().dnd(start, this.control, target);
    }

    public void resize(Dimension size, Window.Direction direction) {
        Point start = null;
        Point target = null;
        Dimension sizeDiff = new Dimension(size.width - this.control.getScreenBounds().width, size.height - this.control.getScreenBounds().height);
        switch (direction) {
            case NORTHWEST: {
                start = new Point(this.offset, this.offset);
                target = new Point(start.x - sizeDiff.width, start.y - sizeDiff.height);
                break;
            }
            case NORTHEAST: {
                start = new Point(this.control.getScreenBounds().width - this.offset - 1, this.offset);
                target = new Point(start.x + sizeDiff.width, start.y - sizeDiff.height);
                break;
            }
            case SOUTHEAST: {
                start = new Point(this.control.getScreenBounds().width - this.offset - 1, this.control.getScreenBounds().height - this.offset - 1);
                target = new Point(start.x + sizeDiff.width, start.y + sizeDiff.height);
                break;
            }
            case SOUTHWEST: {
                start = new Point(this.offset, this.control.getScreenBounds().height - this.offset - 1);
                target = new Point(start.x - sizeDiff.width, start.y + sizeDiff.height);
            }
        }
        this.control.drag().dnd(start, this.control, target);
    }
}

