/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.lookup;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jemmy.control.Wrap;
import org.jemmy.control.Wrapper;
import org.jemmy.env.Environment;
import org.jemmy.env.TestOut;
import org.jemmy.interfaces.ControlInterface;
import org.jemmy.interfaces.TypeControlInterface;
import org.jemmy.lookup.AbstractParent;
import org.jemmy.lookup.Lookup;
import org.jemmy.lookup.LookupCriteria;
import org.jemmy.timing.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLookup<CONTROL>
extends AbstractParent<CONTROL>
implements Lookup<CONTROL> {
    static final String PREFIX_DELTA = "| ";
    private ArrayList<CONTROL> found;
    Environment env;
    private Class<CONTROL> clss;
    private LookupCriteria<CONTROL> criteria = null;
    private Wrapper wrapper;
    public static final String OUTPUT = AbstractLookup.class.getName() + ".OUTPUT";

    public AbstractLookup(Environment env, Class<CONTROL> controlClass, LookupCriteria<CONTROL> criteria, Wrapper wrapper) {
        this.env = env;
        this.found = new ArrayList();
        this.clss = controlClass;
        this.criteria = criteria;
        this.wrapper = wrapper;
    }

    Wrapper getWrapper() {
        return this.wrapper;
    }

    LookupCriteria<CONTROL> getCriteria() {
        return this.criteria;
    }

    Environment getEnvironment() {
        return this.env;
    }

    Class<CONTROL> getControlClass() {
        return this.clss;
    }

    @Override
    public <T extends CONTROL> Lookup<T> lookup(Class<T> controlClass, LookupCriteria<T> criteria) {
        return new ClassLookupImpl(this.env, this, controlClass, criteria, this.wrapper);
    }

    @Override
    public Lookup<CONTROL> lookup(LookupCriteria<CONTROL> criteria) {
        return new ClassLookupImpl(this.env, this, this.clss, criteria, this.wrapper);
    }

    @Override
    public Lookup<? extends CONTROL> wait(final int count) {
        this.getEnvironment().getOutput(OUTPUT).println("Waiting for " + count + " controls of " + this.clss.getName() + " class fitting criteria " + this.criteria);
        this.env.getWaiter(Lookup.WAIT_CONTROL_TIMEOUT.getName()).ensureState(new State<Integer>(){

            @Override
            public Integer reached() {
                if (AbstractLookup.this.found.size() < count) {
                    AbstractLookup.this.refresh();
                }
                return AbstractLookup.this.found.size() >= count ? Integer.valueOf(AbstractLookup.this.found.size()) : null;
            }

            public String toString() {
                return "Waiting for " + count + " " + AbstractLookup.this.clss.getName() + " controls to be found adhering to " + AbstractLookup.this.criteria;
            }
        });
        return this;
    }

    @Override
    public int size() {
        this.getEnvironment().getOutput(OUTPUT).println("Getting number of controls of " + this.clss.getName() + " class fitting criteria " + this.criteria);
        this.refresh();
        return this.found.size();
    }

    void refresh() {
        this.found.clear();
        List childen = this.getChildren(null);
        if (childen != null) {
            for (Object c : childen) {
                this.add(c);
            }
        }
    }

    private void add(Object subparent) {
        if (subparent != null) {
            List childen;
            if (this.clss.isInstance(subparent) && this.check(this.clss.cast(subparent))) {
                this.found.add(this.clss.cast(subparent));
            }
            if ((childen = this.getChildren(subparent)) != null) {
                for (Object child : childen) {
                    this.add(child);
                }
            }
        }
    }

    protected boolean check(CONTROL control) {
        return control != null && this.criteria.check(control);
    }

    @Override
    public Wrap<? extends CONTROL> wrap(int index) {
        return this.instantiate(this.get(index));
    }

    @Override
    public Wrap<? extends CONTROL> wrap() {
        return this.wrap(0);
    }

    @Override
    public <INTERFACE extends ControlInterface> INTERFACE as(int index, Class<INTERFACE> interfaceClass) {
        return this.wrap(index).as(interfaceClass);
    }

    @Override
    public <INTERFACE extends ControlInterface> INTERFACE as(Class<INTERFACE> interfaceClass) {
        return this.as(0, interfaceClass);
    }

    @Override
    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> INTERFACE as(int index, Class<INTERFACE> interfaceClass, Class<TYPE> type) {
        return this.wrap(index).as(interfaceClass, type);
    }

    @Override
    public <TYPE, INTERFACE extends TypeControlInterface<TYPE>> INTERFACE as(Class<INTERFACE> interfaceClass, Class<TYPE> type) {
        return this.as(0, interfaceClass, type);
    }

    @Override
    public CONTROL get(int index) {
        this.wait(index + 1);
        return this.found.get(index);
    }

    @Override
    public CONTROL get() {
        return this.get(0);
    }

    List<CONTROL> getFound() {
        return this.found;
    }

    @Override
    public Class<CONTROL> getType() {
        return this.getControlClass();
    }

    abstract List getChildren(Object var1);

    private String buildClassChain(Class cls) {
        StringBuilder sb = new StringBuilder(cls.getName());
        if (this.getType().isInterface()) {
            sb.append(" implements ").append(this.getType().getName());
        } else {
            do {
                cls = cls.getSuperclass();
                sb.append(" <- ").append(cls.getName());
            } while (!cls.equals(this.getType()) && !cls.equals(Object.class));
        }
        return sb.toString();
    }

    private Wrap<? extends CONTROL> instantiate(CONTROL control) {
        return this.wrapper.wrap(this.clss, control);
    }

    protected void dumpOne(PrintStream out, CONTROL obj, String prefix) {
        HashMap<String, Object> data = this.getWrapper().wrap(this.getControlClass(), this.getControlClass().cast(obj)).getPropertiesQiuet();
        out.println(prefix + "+-" + this.buildClassChain(obj.getClass()));
        for (String key : data.keySet()) {
            out.print(prefix + PREFIX_DELTA + "  " + key + "=");
            if (data.get(key) == null) {
                out.println("null");
                continue;
            }
            out.println(data.get(key));
        }
    }

    protected abstract void dump(PrintStream var1, Lookup<? extends CONTROL> var2);

    @Override
    public void dump(PrintStream out) {
        this.dump(out, this);
    }

    static {
        Environment.getEnvironment().initTimeout(WAIT_CONTROL_TIMEOUT);
        Environment.getEnvironment().initOutput(OUTPUT, TestOut.getNullOutput());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassLookupImpl<T, ST extends T>
    extends AbstractLookup<ST> {
        AbstractLookup<T> parent;
        Class<ST> cls;

        public ClassLookupImpl(Environment env, AbstractLookup<T> parent, Class<ST> cls, LookupCriteria<ST> criteria, Wrapper wrapper) {
            super(env, cls, criteria, wrapper);
            this.cls = cls;
            this.parent = parent;
        }

        @Override
        protected boolean check(ST control) {
            return this.getControlClass().isInstance(control) && super.check(control);
        }

        @Override
        public List getChildren(Object subParent) {
            return this.getFound();
        }

        @Override
        protected void refresh() {
            this.parent.refresh();
            for (Object next : ((AbstractLookup)this.parent).found) {
                if (!this.cls.isInstance(next) || !this.check(this.cls.cast(next))) continue;
                ((AbstractLookup)this).found.add(this.cls.cast(next));
            }
        }

        @Override
        protected void dump(PrintStream out, Lookup<? extends ST> lookup) {
            this.parent.dump(out, lookup);
        }
    }
}

