/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.lookup;

import org.jemmy.control.Wrap;
import org.jemmy.control.Wrapper;
import org.jemmy.env.Environment;
import org.jemmy.lookup.AbstractParent;
import org.jemmy.lookup.ControlHierarchy;
import org.jemmy.lookup.ControlList;
import org.jemmy.lookup.HierarchyLookup;
import org.jemmy.lookup.Lookup;
import org.jemmy.lookup.LookupCriteria;
import org.jemmy.lookup.PlainLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentImpl<T>
extends AbstractParent<T> {
    private Class<T> type;
    private ControlHierarchy ch;
    private ControlList cl;
    private Environment env;
    private Wrapper wrapper;

    public ParentImpl(Environment env, Class<T> type, ControlHierarchy ch) {
        this(env, type, ch, (Wrapper)Wrap.getWrapper());
    }

    public ParentImpl(Environment env, Class<T> type, ControlHierarchy ch, Wrapper wrapper) {
        this.type = type;
        this.ch = ch;
        this.env = env;
        this.wrapper = wrapper;
    }

    public ParentImpl(Environment env, Class<T> type, ControlList cl) {
        this(env, type, cl, (Wrapper)Wrap.getWrapper());
    }

    public ParentImpl(Environment env, Class<T> type, ControlList cl, Wrapper wrapper) {
        this.type = type;
        this.cl = cl;
        this.env = env;
        this.wrapper = wrapper;
    }

    @Override
    public <ST extends T> Lookup<ST> lookup(Class<ST> controlClass, LookupCriteria<ST> criteria) {
        if (this.ch != null) {
            return new HierarchyLookup<ST>(this.env, this.ch, this.wrapper, controlClass, criteria);
        }
        if (this.cl != null) {
            return new PlainLookup<ST>(this.env, this.cl, this.wrapper, controlClass, criteria);
        }
        throw new IllegalStateException();
    }

    @Override
    public Lookup<T> lookup(LookupCriteria<T> criteria) {
        return this.lookup(this.type, criteria);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

