/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.install;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarFile;
import org.jboss.byteman.agent.install.VMInfo;

public class Install {
    private String agentJar = null;
    private String id;
    private int port;
    private String host;
    private boolean addToBoot;
    private boolean setPolicy;
    private String props;
    private VirtualMachine vm;
    private static final String BYTEMAN_PREFIX = "org.jboss.byteman.";
    private static final String BYTEMAN_HOME_SYSTEM_PROP = "org.jboss.byteman.home";
    private static final String BYTEMAN_HOME_ENV_VAR = "BYTEMAN_HOME";

    public static void main(String[] args) {
        Install attachTest = new Install();
        attachTest.parseArgs(args);
        try {
            attachTest.locateAgent();
            attachTest.attach();
            attachTest.injectAgent();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    public static void install(String pid, boolean addToBoot, String host, int port, String[] properties) throws IllegalArgumentException, FileNotFoundException, IOException, AttachNotSupportedException, AgentLoadException, AgentInitializationException {
        Install.install(pid, addToBoot, false, host, port, properties);
    }

    public static void install(String pid, boolean addToBoot, boolean setPolicy, String host, int port, String[] properties) throws IllegalArgumentException, FileNotFoundException, IOException, AttachNotSupportedException, AgentLoadException, AgentInitializationException {
        if (port < 0) {
            throw new IllegalArgumentException("Install : port cannot be negative");
        }
        for (int i = 0; i < properties.length; ++i) {
            String prop = properties[i];
            if (prop == null || prop.length() == 0) {
                throw new IllegalArgumentException("Install : properties  cannot be null or \"\"");
            }
            if (prop.indexOf(44) < 0) continue;
            throw new IllegalArgumentException("Install : properties may not contain ','");
        }
        Install install = new Install(pid, addToBoot, setPolicy, host, port, properties);
        install.locateAgent();
        install.attach();
        install.injectAgent();
    }

    public static VMInfo[] availableVMs() {
        List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
        VMInfo[] vmInfo = new VMInfo[vmds.size()];
        int i = 0;
        for (VirtualMachineDescriptor vmd : vmds) {
            vmInfo[i++] = new VMInfo(vmd.id(), vmd.displayName());
        }
        return vmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSystemProperty(String id, String property) {
        VirtualMachine vm = null;
        try {
            String value;
            vm = VirtualMachine.attach(id);
            String string = value = (String)vm.getSystemProperties().get(property);
            return string;
        }
        catch (AttachNotSupportedException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (vm != null) {
                try {
                    vm.detach();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Install() {
        this.id = null;
        this.port = 0;
        this.addToBoot = false;
        this.props = "";
        this.vm = null;
    }

    private Install(String pid, boolean addToBoot, String host, int port, String[] properties) {
        this(pid, addToBoot, false, host, port, properties);
    }

    private Install(String pid, boolean addToBoot, boolean setPolicy, String host, int port, String[] properties) {
        this.id = pid;
        this.port = port;
        this.addToBoot = addToBoot;
        this.setPolicy = setPolicy;
        this.host = host;
        if (properties != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < properties.length; ++i) {
                builder.append(",prop:");
                builder.append(properties[i]);
            }
            this.props = builder.toString();
        } else {
            this.props = "";
        }
        this.vm = null;
    }

    private void parseArgs(String[] args) {
        int idx = 0;
        int argCount = args.length;
        if (idx == argCount) {
            Install.usage(0);
        }
        String nextArg = args[idx];
        while (nextArg.length() != 0 && nextArg.charAt(0) == '-') {
            if (nextArg.equals("-p")) {
                if (++idx == argCount) {
                    Install.usage(1);
                }
                nextArg = args[idx];
                ++idx;
                try {
                    this.port = Integer.decode(nextArg);
                }
                catch (NumberFormatException e) {
                    System.out.println("Install : invalid value for port " + nextArg);
                    Install.usage(1);
                }
            } else if (nextArg.equals("-h")) {
                if (++idx == argCount) {
                    Install.usage(1);
                }
                nextArg = args[idx];
                ++idx;
                this.host = nextArg;
            } else if (nextArg.equals("-b")) {
                ++idx;
                this.addToBoot = true;
            } else if (nextArg.equals("-s")) {
                ++idx;
                this.setPolicy = true;
            } else if (nextArg.startsWith("-D")) {
                ++idx;
                String prop = nextArg.substring(2);
                if (!prop.startsWith(BYTEMAN_PREFIX) || prop.contains(",")) {
                    System.out.println("Install : invalid property setting " + prop);
                    Install.usage(1);
                }
                this.props = this.props + ",prop:" + prop;
            } else if (nextArg.equals("--help")) {
                Install.usage(0);
            } else {
                System.out.println("Install : invalid option " + args[idx]);
                Install.usage(1);
            }
            if (idx == argCount) {
                Install.usage(1);
            }
            nextArg = args[idx];
        }
        if (idx != argCount - 1) {
            Install.usage(1);
        }
        this.id = nextArg;
    }

    private void locateAgent() throws IOException {
        String bmHome = System.getProperty(BYTEMAN_HOME_SYSTEM_PROP);
        if (bmHome == null || bmHome.length() == 0) {
            bmHome = System.getenv(BYTEMAN_HOME_ENV_VAR);
            if (bmHome == null || bmHome.length() == 0 || bmHome.equals("null")) {
                this.locateAgentFromClasspath();
            } else {
                this.locateAgentFromHomeDir(bmHome);
            }
        }
    }

    public void locateAgentFromHomeDir(String bmHome) throws IOException {
        File bmHomeFile;
        if (bmHome.endsWith("/")) {
            bmHome = bmHome.substring(0, bmHome.length() - 1);
        }
        if (!(bmHomeFile = new File(bmHome)).isDirectory()) {
            throw new FileNotFoundException("Install : ${BYTEMAN_HOME} does not identify a directory");
        }
        File bmLibFile = new File(bmHome + "/lib");
        if (!bmLibFile.isDirectory()) {
            throw new FileNotFoundException("Install : ${BYTEMAN_HOME}/lib does not identify a directory");
        }
        try {
            JarFile jarFile = new JarFile(bmHome + "/lib/byteman.jar");
        }
        catch (IOException e) {
            throw new IOException("Install : ${BYTEMAN_HOME}/lib/byteman.jar is not a valid jar file");
        }
        this.agentJar = bmHome + "/lib/byteman.jar";
    }

    public void locateAgentFromClasspath() throws IOException {
        String javaClassPath = System.getProperty("java.class.path");
        String pathSepr = System.getProperty("path.separator");
        String fileSepr = System.getProperty("file.separator");
        String EXTENSION = ".jar";
        int EXTENSION_LEN = ".jar".length();
        String NAME = "byteman";
        int NAME_LEN = "byteman".length();
        String VERSION_PATTERN = "-[0-9]+\\.[0-9]+\\.[0-9]+.*";
        String[] elements = javaClassPath.split(pathSepr);
        String jarname = null;
        for (String element : elements) {
            if (!element.endsWith(".jar")) continue;
            String name = element.substring(0, element.length() - EXTENSION_LEN);
            int lastFileSepr = name.lastIndexOf(fileSepr);
            if (lastFileSepr >= 0) {
                name = name.substring(lastFileSepr + 1);
            }
            if (!name.startsWith("byteman")) continue;
            if (name.length() == NAME_LEN) {
                jarname = element;
                break;
            }
            String version = name.substring(NAME_LEN);
            if (!version.matches("-[0-9]+\\.[0-9]+\\.[0-9]+.*")) continue;
            jarname = element;
            break;
        }
        if (jarname == null) {
            throw new FileNotFoundException("Install : cannot find Byteman agent jar please set environment variable BYTEMAN_HOME or System property org.jboss.byteman.home");
        }
        this.agentJar = jarname;
        System.out.println("byteman jar is " + jarname);
    }

    private void attach() throws AttachNotSupportedException, IOException, IllegalArgumentException {
        int pid;
        if (this.id.matches("[0-9]+")) {
            pid = Integer.valueOf(this.id);
            if (pid <= 0) {
                throw new IllegalArgumentException("Install : invalid pid " + this.id);
            }
        } else {
            int spacePos;
            String displayName;
            List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
            for (VirtualMachineDescriptor vmd : vmds) {
                displayName = vmd.displayName();
                spacePos = displayName.indexOf(32);
                if (spacePos > 0) {
                    displayName = displayName.substring(0, spacePos);
                }
                if (!displayName.equals(this.id)) continue;
                String pid2 = vmd.id();
                this.vm = VirtualMachine.attach(vmd);
                return;
            }
            for (VirtualMachineDescriptor vmd : vmds) {
                int idx;
                displayName = vmd.displayName();
                spacePos = displayName.indexOf(32);
                if (spacePos > 0) {
                    displayName = displayName.substring(0, spacePos);
                }
                if (displayName.indexOf(46) < 0 || !displayName.endsWith(this.id) || displayName.charAt(idx = displayName.length() - (this.id.length() + 1)) != '.') continue;
                String pid3 = vmd.id();
                this.vm = VirtualMachine.attach(vmd);
                return;
            }
            throw new IllegalArgumentException("Install : invalid pid " + this.id);
        }
        this.vm = VirtualMachine.attach(Integer.toString(pid));
    }

    private void injectAgent() throws AgentLoadException, AgentInitializationException, IOException {
        try {
            String agentOptions = "listener:true";
            if (this.host != null && this.host.length() != 0) {
                agentOptions = agentOptions + ",address:" + this.host;
            }
            if (this.port != 0) {
                agentOptions = agentOptions + ",port:" + this.port;
            }
            if (this.addToBoot) {
                agentOptions = agentOptions + ",boot:" + this.agentJar;
            }
            if (this.setPolicy) {
                agentOptions = agentOptions + ",policy:true";
            }
            if (this.props != null) {
                agentOptions = agentOptions + this.props;
            }
            this.vm.loadAgent(this.agentJar, agentOptions);
        }
        finally {
            this.vm.detach();
        }
    }

    private static void usage(int exitValue) {
        System.out.println("usage : Install [-h host] [-p port] [-b] [-Dprop[=value]]* pid");
        System.out.println("        upload the byteman agent into a running JVM");
        System.out.println("    pid is the process id of the target JVM or the unique name of the process as reported by the jps -l command");
        System.out.println("    -h host selects the host name or address the agent listener binds to");
        System.out.println("    -p port selects the port the agent listener binds to");
        System.out.println("    -b adds the byteman jar to the bootstrap classpath");
        System.out.println("    -s sets an access-all-areas security policy for the Byteman agent code");
        System.out.println("    -Dname=value can be used to set system properties whose name starts with \"org.jboss.byteman.\"");
        System.out.println("    expects to find a byteman agent jar in ${BYTEMAN_HOME}/lib/byteman.jar");
        System.out.println("    (alternatively set System property org.jboss.byteman.home to overide ${BYTEMAN_HOME})");
        System.exit(exitValue);
    }
}

