/*
 * Decompiled with CFR 0.152.
 */
package com.look;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.decomposition.SingularValueDecompositionMTJ;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseRowMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseVector;
import gov.sandia.cognition.math.matrix.mtj.SparseVectorFactoryMTJ;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;

public class LoadedClasses {
    private static void svd() {
        DenseMatrix m2 = DenseMatrixFactoryMTJ.INSTANCE.createMatrix(3, 4);
        m2.setElement(0, 0, 1.0);
        m2.setElement(0, 1, 2.0);
        m2.setElement(0, 2, 3.0);
        m2.setElement(0, 3, 4.0);
        m2.setElement(1, 0, 5.0);
        m2.setElement(1, 1, 6.0);
        m2.setElement(1, 2, -1.0);
        m2.setElement(1, 3, -2.0);
        m2.setElement(2, 0, -3.0);
        m2.setElement(2, 1, -4.0);
        m2.setElement(2, 2, -5.0);
        m2.setElement(2, 3, -6.0);
        SingularValueDecompositionMTJ instance = SingularValueDecompositionMTJ.create(m2);
        instance.norm2();
        instance.conditionNumber();
        instance.rank();
        instance.effectiveRank(0.0);
        instance.pseudoInverse(0.5);
    }

    private static void matrices() {
        Vector x0 = VectorFactory.getDefault().createVector(3);
        System.out.println("x0 = " + x0);
        x0.setElement(0, 1.0);
        x0.setElement(1, 2.0);
        x0.setElement(2, 3.0);
        System.out.println("x0: " + x0);
        try {
            x0.setElement(x0.getDimensionality(), 0.0);
        }
        catch (Exception e) {
            System.out.println("Threw exception: " + e.getClass().getName());
        }
        System.out.println("x0(0): " + x0.getElement(0));
        System.out.println("x0(1): " + x0.getElement(1));
        System.out.println("x0(2): " + x0.getElement(2));
        try {
            x0.getElement(-1);
        }
        catch (Exception e) {
            System.out.println("Threw exception: " + e.getClass().getName());
        }
        Vector x1 = VectorFactory.getDefault().copyValues(1.0, 2.0, 3.0);
        System.out.println("x1 = " + x1);
        Matrix identity = MatrixFactory.getDefault().createIdentity(3, 3);
        System.out.println("Identity (3x3):\n" + identity);
        Vector y1 = identity.times(x1);
        System.out.println("y1 = I*x1 = " + y1);
        System.out.println("y1 == x1: " + y1.equals(x1));
        double scaleFactor = 10.0;
        Vector y1scaled1 = ((Matrix)identity.scale(10.0)).times(x1);
        System.out.println("y1scaled1 = (10*I)*x1: " + y1scaled1);
        Vector y1scaled2 = (Vector)identity.times(x1).scale(10.0);
        System.out.println("y1scaled1 = I*(x1*10): " + y1scaled2);
        System.out.println("y1scaled1 == y1scaled2: " + y1scaled1.equals(y1scaled2));
        Matrix identityClone = identity.clone();
        identity.scaleEquals(10.0);
        Vector y1scaled3 = identity.times(x1);
        System.out.println("y1scaled1 == y1scaled3: " + y1scaled1.equals(y1scaled3));
        x1.scaleEquals(10.0);
        Vector y1scaled4 = identityClone.times(x1);
        System.out.println("y1scaled1 == y1scaled4: " + y1scaled1.equals(y1scaled4));
        Matrix Ibad = MatrixFactory.getDefault().createIdentity(4, 2);
        try {
            Ibad.times(x1);
        }
        catch (Exception e) {
            System.out.println("Caught an exception of type: " + e.getClass().getName());
        }
        Vector c1 = VectorFactory.getDefault().copyValues(1.0, 2.0, 3.0);
        Vector c2 = VectorFactory.getDefault().copyValues(0.0, 1.0, 0.0);
        Vector c3 = c1;
        Vector c4 = c2;
        Matrix matrix = MatrixFactory.getDefault().copyColumnVectors(Arrays.asList(c1, c2, c3, c4));
        System.out.println("matrix =\n" + matrix);
        SingularValueDecompositionMTJ svd = SingularValueDecompositionMTJ.create(matrix);
        System.out.println("U =\n" + svd.getU());
        System.out.println("S =\n" + svd.getS());
        System.out.println("Vt =\n" + svd.getVtranspose());
        double tolerance = 1.0E-10;
        System.out.println("Effective Rank of A = " + svd.effectiveRank(1.0E-10));
        SparseMatrix sparse1 = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(10, 5);
        System.out.println("Sparse with no nonzero entries\n" + sparse1);
        sparse1.setElement(1, 2, 1.0);
        sparse1.setElement(5, 3, 0.2);
        System.out.println("Sparse with 2 nonzero entries \n" + sparse1);
        sparse1.setElement(1, 2, 0.0);
        System.out.println("Sparse with a nonzero entry returned to zero\n" + sparse1);
        sparse1.compact();
        System.out.println("Sparse that has been compacted\n" + sparse1);
        SparseMatrix sparse2 = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(2, 2);
        sparse2.setElement(0, 0, 1.0);
        sparse2.setElement(0, 1, 2.0);
        sparse2.setElement(1, 0, 3.0);
        sparse2.setElement(1, 1, 4.0);
        SparseMatrix sparse3 = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(2, 2);
        sparse3.setElement(0, 0, 1.0);
        sparse3.setElement(0, 1, 1.0);
        sparse3.setElement(1, 0, 1.0);
        sparse3.setElement(1, 1, 1.0);
        SparseRowMatrix m = sparse2.times(sparse3);
        System.out.println("m = \n" + m);
        int[][] nArrayArray = new int[5][];
        nArrayArray[0] = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray = new int[10];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[10];
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 1;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[10];
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = 1;
        nArray3[9] = 1;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[10];
        nArray4[8] = 1;
        nArray4[9] = 1;
        nArrayArray[4] = nArray4;
        int[][] connectedSynapses = nArrayArray;
        int[] inputVector = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] results = new int[5];
        int[] trueResults = new int[]{10, 8, 6, 4, 2};
        results = LoadedClasses.rightVecSumAtNZ(inputVector, connectedSynapses);
        int i = 0;
        while (i < results.length) {
            System.out.println("? " + (trueResults[i] == results[i]));
            ++i;
        }
        SparseMatrix sparse4 = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(5, 10);
        int i2 = 0;
        while (i2 < sparse4.getNumRows()) {
            int j = 0;
            while (j < 10) {
                sparse4.set(i2, j, connectedSynapses[i2][j]);
                ++j;
            }
            ++i2;
        }
        double[] inputVectorD = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        SparseVector inVec = SparseVectorFactoryMTJ.INSTANCE.createVector(10);
        int i3 = 0;
        while (i3 < inputVectorD.length) {
            inVec.set(i3, 1.0);
            ++i3;
        }
        SparseVector collector = SparseVectorFactoryMTJ.INSTANCE.createVector(5);
        int i4 = 0;
        while (i4 < sparse4.getNumRows()) {
            for (VectorEntry ve : sparse4.getRow(i4)) {
                collector.set(i4, collector.get(i4) + (double)inputVector[ve.getIndex()] * ve.getValue());
            }
            ++i4;
        }
        System.out.println("col = \n" + collector);
        SparseMatrix sparse5 = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(0, 10);
        int i5 = 0;
        while (i5 < connectedSynapses.length) {
            sparse5.addRow(connectedSynapses[i5]);
            ++i5;
        }
        SparseVector deleted = sparse5.delRow(2);
        System.out.println("deleted = " + deleted.toString());
        System.out.println("numRows = " + sparse5.getNumRows());
        SparseVector deleted2 = sparse5.delRow(3);
        System.out.println("deleted = " + deleted2);
        System.out.println("numRows = " + sparse5.getNumRows());
        System.out.println("sparse5 = \n" + sparse5.toString());
    }

    public static int[] rightVecSumAtNZ(int[] inputVector, int[][] base) {
        int[] results = new int[base.length];
        int i = 0;
        while (i < base.length) {
            int j = 0;
            while (j < base[i].length) {
                if (inputVector[j] != 0) {
                    int n = i;
                    results[n] = results[n] + inputVector[j] * base[i][j];
                }
                ++j;
            }
            System.out.println("row " + i + " = " + Arrays.toString(results));
            ++i;
        }
        return results;
    }

    private static Iterator<Class<?>> list(ClassLoader CL) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> CL_class = CL.getClass();
        while (CL_class != ClassLoader.class) {
            CL_class = CL_class.getSuperclass();
        }
        Field ClassLoader_classes_field = CL_class.getDeclaredField("classes");
        ClassLoader_classes_field.setAccessible(true);
        java.util.Vector classes = (java.util.Vector)ClassLoader_classes_field.get(CL);
        return classes.iterator();
    }

    public static void main(String[] args) throws Exception {
        LoadedClasses.svd();
        LoadedClasses.matrices();
        ClassLoader myCL = Thread.currentThread().getContextClassLoader();
        while (myCL != null) {
            System.out.println("ClassLoader: " + myCL);
            Iterator<Class<?>> iter = LoadedClasses.list(myCL);
            while (iter.hasNext()) {
                System.out.println("\t" + iter.next());
            }
            myCL = myCL.getParent();
        }
    }
}

