/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.algorithm;

import gov.sandia.cognition.algorithm.IterativeAlgorithm;
import gov.sandia.cognition.algorithm.IterativeAlgorithmListener;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.LinkedList;

public abstract class AbstractIterativeAlgorithm
extends AbstractCloneableSerializable
implements IterativeAlgorithm {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_ITERATION = 0;
    private transient LinkedList<IterativeAlgorithmListener> listeners;
    protected int iteration;

    public AbstractIterativeAlgorithm() {
        this(0);
    }

    public AbstractIterativeAlgorithm(int iteration) {
        this.setIteration(iteration);
        this.setListeners(null);
    }

    @Override
    public AbstractIterativeAlgorithm clone() {
        AbstractIterativeAlgorithm result = (AbstractIterativeAlgorithm)super.clone();
        result.iteration = 0;
        result.listeners = null;
        return result;
    }

    protected void fireAlgorithmStarted() {
        if (this.listeners != null) {
            for (IterativeAlgorithmListener listener : this.listeners) {
                listener.algorithmStarted(this);
            }
        }
    }

    protected void fireAlgorithmEnded() {
        if (this.listeners != null) {
            for (IterativeAlgorithmListener listener : this.listeners) {
                listener.algorithmEnded(this);
            }
        }
    }

    protected void fireStepStarted() {
        if (this.listeners != null) {
            for (IterativeAlgorithmListener listener : this.listeners) {
                listener.stepStarted(this);
            }
        }
    }

    protected void fireStepEnded() {
        if (this.listeners != null) {
            for (IterativeAlgorithmListener listener : this.listeners) {
                listener.stepEnded(this);
            }
        }
    }

    @Override
    public void addIterativeAlgorithmListener(IterativeAlgorithmListener listener) {
        if (this.getListeners() == null) {
            this.setListeners(new LinkedList<IterativeAlgorithmListener>());
        }
        this.getListeners().add(listener);
    }

    @Override
    public void removeIterativeAlgorithmListener(IterativeAlgorithmListener listener) {
        if (this.getListeners() == null) {
            return;
        }
        this.getListeners().remove(listener);
        if (this.getListeners().isEmpty()) {
            this.setListeners(null);
        }
    }

    protected LinkedList<IterativeAlgorithmListener> getListeners() {
        return this.listeners;
    }

    protected void setListeners(LinkedList<IterativeAlgorithmListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public int getIteration() {
        return this.iteration;
    }

    protected void setIteration(int iteration) {
        this.iteration = iteration;
    }
}

