/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class CollectionUtil {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static <DataType> ArrayList<DataType> asArrayList(Iterable<DataType> data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayList) {
            return (ArrayList)data;
        }
        if (data instanceof Collection) {
            return new ArrayList((Collection)data);
        }
        int num = CollectionUtil.size(data);
        ArrayList<DataType> retval = new ArrayList<DataType>(num);
        for (DataType value : data) {
            retval.add(value);
        }
        return retval;
    }

    public static int size(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static int size(Iterable<?> iterable) {
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        int counter = 0;
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++counter;
        }
        return counter;
    }

    public static <T> T getFirst(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> T getFirst(List<? extends T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T getLast(List<? extends T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <ComparableType> int[] findKthLargest(int k, ArrayList<? extends ComparableType> data, Comparator<? super ComparableType> comparator) {
        int num = data.size();
        int[] indices = new int[num];
        int i = 0;
        while (i < num) {
            indices[i] = i;
            ++i;
        }
        int leftIndex = 0;
        int rightIndex = num - 1;
        while (true) {
            if (rightIndex <= leftIndex + 1) {
                if (rightIndex == leftIndex + 1) {
                    CollectionUtil.swapIfAGreaterThanB(leftIndex, rightIndex, indices, data, comparator);
                }
                return indices;
            }
            int mid = (leftIndex + rightIndex) / 2;
            CollectionUtil.swapArrayValues(mid, leftIndex + 1, indices);
            CollectionUtil.swapIfAGreaterThanB(leftIndex, rightIndex, indices, data, comparator);
            CollectionUtil.swapIfAGreaterThanB(leftIndex + 1, rightIndex, indices, data, comparator);
            CollectionUtil.swapIfAGreaterThanB(leftIndex, leftIndex + 1, indices, data, comparator);
            int i2 = leftIndex + 1;
            int originali = indices[i2];
            int j = rightIndex;
            ComparableType valueOriginali = data.get(originali);
            while (true) {
                if (comparator.compare(data.get(indices[++i2]), valueOriginali) < 0) {
                    continue;
                }
                while (comparator.compare(data.get(indices[--j]), valueOriginali) > 0) {
                }
                if (j < i2) break;
                CollectionUtil.swapArrayValues(i2, j, indices);
            }
            indices[leftIndex + 1] = indices[j];
            indices[j] = originali;
            if (j >= k) {
                rightIndex = j - 1;
            }
            if (j > k) continue;
            leftIndex = i2;
        }
    }

    private static <ComparableType> boolean swapIfAGreaterThanB(int a, int b, int[] indices, ArrayList<? extends ComparableType> data, Comparator<? super ComparableType> comparator) {
        boolean doSwap;
        boolean bl = doSwap = comparator.compare(data.get(indices[a]), data.get(indices[b])) > 0;
        if (doSwap) {
            CollectionUtil.swapArrayValues(a, b, indices);
        }
        return doSwap;
    }

    private static void swapArrayValues(int i1, int i2, int[] indices) {
        int temp = indices[i1];
        indices[i1] = indices[i2];
        indices[i2] = temp;
    }

    public static <DataType> ArrayList<List<? extends DataType>> createSequentialPartitions(Iterable<? extends DataType> data, int numPartitions) {
        if (data instanceof List) {
            List list = (List)data;
            return CollectionUtil.createSequentialPartitions(list, numPartitions);
        }
        int numData = CollectionUtil.size(data);
        int numEach = numData / numPartitions;
        ArrayList<List<DataType>> retval = new ArrayList<List<DataType>>(numPartitions);
        int index = 0;
        Iterator<DataType> iterator = data.iterator();
        int n = 0;
        while (n < numPartitions) {
            int numThis = n < numPartitions - 1 ? numEach : numData - index;
            ArrayList<DataType> partition = new ArrayList<DataType>(numThis);
            int i = 0;
            while (i < numThis) {
                partition.add(iterator.next());
                ++index;
                ++i;
            }
            retval.add(partition);
            ++n;
        }
        return retval;
    }

    public static <DataType> ArrayList<List<? extends DataType>> createSequentialPartitions(List<? extends DataType> data, int numPartitions) {
        int numData = CollectionUtil.size(data);
        int numEach = numData / numPartitions;
        ArrayList<List<DataType>> result = new ArrayList<List<DataType>>(numPartitions);
        int beginIndex = 0;
        int endIndex = beginIndex + numEach;
        int i = 0;
        while (i < numPartitions) {
            if (i == numPartitions - 1) {
                endIndex = numData;
            }
            result.add(data.subList(beginIndex, endIndex));
            beginIndex = endIndex;
            endIndex += numEach;
            ++i;
        }
        return result;
    }

    public static <DataType> DataType getElement(Iterable<DataType> iterable, int index) {
        if (iterable instanceof List) {
            return (DataType)((List)iterable).get(index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        for (DataType v : iterable) {
            if (index == 0) {
                return v;
            }
            --index;
        }
        throw new IndexOutOfBoundsException("index >= iterable size");
    }

    public static <DataType> DataType removeElement(Iterable<DataType> iterable, int index) {
        if (iterable instanceof List) {
            return (DataType)((List)iterable).remove(index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        Iterator<DataType> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            DataType value = iterator.next();
            if (index == 0) {
                iterator.remove();
                return value;
            }
            --index;
        }
        throw new IndexOutOfBoundsException("index >= iterable size");
    }

    public static String toStringDelimited(Iterable<?> list, String delimiter) {
        if (list == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer();
        Iterator<?> iterator = list.iterator();
        if (iterator.hasNext()) {
            result.append(iterator.next());
        }
        while (iterator.hasNext()) {
            result.append(delimiter);
            result.append(iterator.next());
        }
        return result.toString();
    }

    public static <DataType> ArrayList<DataType> createArrayList(DataType first, DataType second) {
        ArrayList<DataType> result = new ArrayList<DataType>(2);
        result.add(first);
        result.add(second);
        return result;
    }

    public static <KeyType, ValueType> HashMap<KeyType, ValueType> createHashMapWithSize(int size) {
        int initialCapacity = (int)Math.ceil((float)size / 0.75f);
        return new HashMap(initialCapacity, 0.75f);
    }

    public static <KeyType, ValueType> LinkedHashMap<KeyType, ValueType> createLinkedHashMapWithSize(int size) {
        int initialCapacity = (int)Math.ceil((float)size / 0.75f);
        return new LinkedHashMap(initialCapacity, 0.75f);
    }

    public static <ValueType> HashSet<ValueType> createHashSetWithSize(int size) {
        int initialCapacity = (int)Math.ceil((float)size / 0.75f);
        return new HashSet(initialCapacity, 0.75f);
    }

    public static <ValueType> LinkedHashSet<ValueType> createLinkedHashSetWithSize(int size) {
        int initialCapacity = (int)Math.ceil((float)size / 0.75f);
        return new LinkedHashSet(initialCapacity, 0.75f);
    }
}

