/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;

public abstract class AbstractRing<RingType extends Ring<RingType>>
extends AbstractCloneableSerializable
implements Ring<RingType> {
    private static final long serialVersionUID = 1L;

    @Override
    public RingType clone() {
        return (RingType)((Ring)super.clone());
    }

    @Override
    public RingType dotTimes(RingType other) {
        CloneableSerializable copy = this.clone();
        copy.dotTimesEquals(other);
        return (RingType)copy;
    }

    @Override
    public RingType minus(RingType other) {
        CloneableSerializable copy = this.clone();
        copy.minusEquals(other);
        return (RingType)copy;
    }

    @Override
    public RingType plus(RingType other) {
        CloneableSerializable copy = this.clone();
        copy.plusEquals(other);
        return (RingType)copy;
    }

    @Override
    public RingType scale(double scaleFactor) {
        CloneableSerializable copy = this.clone();
        copy.scaleEquals(scaleFactor);
        return (RingType)copy;
    }

    @Override
    public RingType scaledPlus(double scaleFactor, RingType other) {
        CloneableSerializable copy = this.clone();
        copy.scaledPlusEquals(scaleFactor, other);
        return (RingType)copy;
    }

    @Override
    public RingType scaledMinus(double scaleFactor, RingType other) {
        CloneableSerializable copy = this.clone();
        copy.scaledMinusEquals(scaleFactor, other);
        return (RingType)copy;
    }

    @Override
    public void scaledMinusEquals(double scaleFactor, RingType other) {
        this.scaledPlusEquals(-scaleFactor, other);
    }

    @Override
    public RingType negative() {
        CloneableSerializable copy = this.clone();
        copy.negativeEquals();
        return (RingType)copy;
    }

    @Override
    public void negativeEquals() {
        this.scaleEquals(-1.0);
    }

    @Override
    public void zero() {
        this.scaleEquals(0.0);
    }

    @Override
    public boolean isZero() {
        return this.isZero(0.0);
    }
}

