/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.AbstractField;
import java.io.Serializable;

public class ComplexNumber
extends AbstractField<ComplexNumber>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double realPart;
    private double imaginaryPart;

    public ComplexNumber() {
        this(0.0, 0.0);
    }

    public ComplexNumber(double realPart, double imaginaryPart) {
        this.setRealPart(realPart);
        this.setImaginaryPart(imaginaryPart);
    }

    public ComplexNumber(ComplexNumber other) {
        this(other.getRealPart(), other.getImaginaryPart());
    }

    @Override
    public ComplexNumber clone() {
        return (ComplexNumber)super.clone();
    }

    @Override
    public void plusEquals(ComplexNumber number) {
        double x = this.getRealPart() + number.getRealPart();
        double y = this.getImaginaryPart() + number.getImaginaryPart();
        this.setRealPart(x);
        this.setImaginaryPart(y);
    }

    public double getMagnitude() {
        double x = this.getRealPart();
        double y = this.getImaginaryPart();
        return Math.sqrt(x * x + y * y);
    }

    public double getPhase() {
        double x = this.getRealPart();
        double y = this.getImaginaryPart();
        return Math.atan2(y, x);
    }

    public ComplexNumber computeExponent() {
        double r = Math.exp(this.getRealPart());
        double phase = this.getImaginaryPart();
        double x = r * Math.cos(phase);
        double y = r * Math.sin(phase);
        return new ComplexNumber(x, y);
    }

    public ComplexNumber computeNaturalLogarithm() {
        double r = this.getMagnitude();
        double phase = this.getPhase();
        double x = Math.log(r);
        double y = phase;
        return new ComplexNumber(x, y);
    }

    @Override
    public void dotTimesEquals(ComplexNumber other) {
        this.setRealPart(this.getRealPart() * other.getRealPart());
        this.setImaginaryPart(this.getImaginaryPart() * other.getImaginaryPart());
    }

    @Override
    public void minusEquals(ComplexNumber other) {
        this.setRealPart(this.getRealPart() - other.getRealPart());
        this.setImaginaryPart(this.getImaginaryPart() - other.getImaginaryPart());
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        this.setRealPart(this.getRealPart() * scaleFactor);
        this.setImaginaryPart(this.getImaginaryPart() * scaleFactor);
    }

    @Override
    public void scaledPlusEquals(double scaleFactor, ComplexNumber other) {
        this.realPart += scaleFactor * other.realPart;
        this.imaginaryPart += scaleFactor * other.imaginaryPart;
    }

    @Override
    public ComplexNumber times(ComplexNumber other) {
        ComplexNumber copy = this.clone();
        copy.timesEquals(other);
        return copy;
    }

    @Override
    public void timesEquals(ComplexNumber other) {
        double r = this.getMagnitude() * other.getMagnitude();
        double theta = this.getPhase() + other.getPhase();
        this.setRealPart(r * Math.cos(theta));
        this.setImaginaryPart(r * Math.sin(theta));
    }

    @Override
    public ComplexNumber divide(ComplexNumber other) {
        ComplexNumber copy = this.clone();
        copy.divideEquals(other);
        return copy;
    }

    @Override
    public void divideEquals(ComplexNumber other) {
        double r = this.getMagnitude() / other.getMagnitude();
        double theta = this.getPhase() - other.getPhase();
        this.setRealPart(r * Math.cos(theta));
        this.setImaginaryPart(r * Math.sin(theta));
    }

    @Deprecated
    public ComplexNumber dividedBy(ComplexNumber other) {
        return this.divide(other);
    }

    @Deprecated
    public void dividedByEquals(ComplexNumber other) {
        this.divideEquals(other);
    }

    @Override
    public void inverseEquals() {
        double divisor = this.realPart * this.realPart + this.imaginaryPart * this.imaginaryPart;
        this.setRealPart(this.realPart / divisor);
        this.setImaginaryPart(-this.imaginaryPart / divisor);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.realPart) ^ Double.doubleToLongBits(this.realPart) >>> 32);
        hash = 47 * hash + (int)(Double.doubleToLongBits(this.imaginaryPart) ^ Double.doubleToLongBits(this.imaginaryPart) >>> 32);
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof ComplexNumber) {
            return this.equals((ComplexNumber)other, 0.0);
        }
        return false;
    }

    @Override
    public boolean equals(ComplexNumber other, double effectiveZero) {
        double realDifference = this.getRealPart() - other.getRealPart();
        if (Math.abs(realDifference) > effectiveZero) {
            return false;
        }
        double imaginaryDifference = this.getImaginaryPart() - other.getImaginaryPart();
        return !(Math.abs(imaginaryDifference) > effectiveZero);
    }

    public String toString() {
        return String.valueOf(this.getRealPart()) + " + j" + this.getImaginaryPart();
    }

    public double getRealPart() {
        return this.realPart;
    }

    public void setRealPart(double realPart) {
        this.realPart = realPart;
    }

    public double getImaginaryPart() {
        return this.imaginaryPart;
    }

    public void setImaginaryPart(double imaginaryPart) {
        this.imaginaryPart = imaginaryPart;
    }

    public void conjugateEquals() {
        this.imaginaryPart *= -1.0;
    }

    public ComplexNumber conjugate() {
        return new ComplexNumber(this.getRealPart(), -this.getImaginaryPart());
    }

    @Override
    public boolean isZero(double effectiveZero) {
        return Math.abs(this.realPart) <= effectiveZero && Math.abs(this.imaginaryPart) <= effectiveZero;
    }
}

