/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.algorithm.AbstractAnytimeAlgorithm;
import gov.sandia.cognition.math.OperationNotConvergedException;

public class LentzMethod
extends AbstractAnytimeAlgorithm<Double> {
    private static final long serialVersionUID = 1L;
    static final double DEFAULT_MIN_DENOMINATOR = 1.0E-30;
    static final int DEFAULT_MAX_ITERATIONS = 100;
    static final double DEFAULT_TOLERANCE = 3.0E-7;
    private double tolerance;
    private double minDenominator;
    private double currentC;
    private double currentD;
    private Double result;
    private double fractionValue;
    private boolean keepGoing;

    public LentzMethod() {
        this(100, 3.0E-7, 1.0E-30);
    }

    public LentzMethod(int maxIterations, double tolerance, double minDenominator) {
        super(maxIterations);
        this.setTolerance(tolerance);
        this.setMinDenominator(minDenominator);
        this.keepGoing = false;
        this.result = null;
    }

    public boolean initializeAlgorithm(double b0) {
        this.fireAlgorithmStarted();
        this.result = null;
        this.fractionValue = b0;
        if (Math.abs(this.fractionValue) < this.minDenominator) {
            this.fractionValue = this.minDenominator;
        }
        this.currentC = this.fractionValue;
        this.currentD = 0.0;
        this.iteration = 0;
        this.keepGoing = this.iteration < this.maxIterations;
        return this.keepGoing;
    }

    public boolean iterate(double a, double b) {
        if (!this.keepGoing) {
            throw new OperationNotConvergedException("Trying to iterate when keepGoing is false!");
        }
        this.fireStepStarted();
        ++this.iteration;
        this.currentD = b + a * this.currentD;
        this.currentC = b + a / this.currentC;
        if (Math.abs(this.currentD) < this.minDenominator) {
            this.currentD = this.minDenominator;
        }
        this.currentD = 1.0 / this.currentD;
        if (Math.abs(this.currentC) < this.minDenominator) {
            this.currentC = this.minDenominator;
        }
        double delta = this.currentC * this.currentD;
        this.fractionValue *= delta;
        if (Math.abs(delta - 1.0) < this.tolerance) {
            this.result = this.getFractionValue();
            this.keepGoing = false;
        }
        if (this.iteration >= this.maxIterations) {
            this.keepGoing = false;
        }
        this.fireStepEnded();
        if (!this.keepGoing) {
            this.fireAlgorithmEnded();
        }
        return this.keepGoing;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getMinDenominator() {
        return this.minDenominator;
    }

    public void setMinDenominator(double minDenominator) {
        this.minDenominator = minDenominator;
    }

    @Override
    public Double getResult() {
        return this.result;
    }

    @Override
    public void stop() {
        this.keepGoing = false;
    }

    public boolean getKeepGoing() {
        return this.keepGoing;
    }

    public double getFractionValue() {
        return this.fractionValue;
    }

    protected void setFractionValue(double fractionValue) {
        this.fractionValue = fractionValue;
    }
}

