/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.LentzMethod;
import gov.sandia.cognition.math.LogMath;
import gov.sandia.cognition.math.OperationNotConvergedException;
import gov.sandia.cognition.math.matrix.Vector;

public class MathUtil {
    public static double log(double x, double base) {
        return Math.log(x) / Math.log(base);
    }

    public static double log2(double x) {
        return Math.log(x) / LogMath.LOG_2;
    }

    public static double logGammaFunction(double input) {
        if (input <= 0.0) {
            throw new IllegalArgumentException("Input must be > 0.0");
        }
        double xx = input;
        double tmp = xx + 4.5;
        tmp -= (xx - 0.5) * Math.log(tmp);
        double ser = 1.000000000190015 + 76.18009172947146 / xx - 86.50532032941678 / (xx + 1.0) + 24.01409824083091 / (xx + 2.0) - 1.231739572450155 / (xx + 3.0) + 0.001208650973866179 / (xx + 4.0) - 5.395239384953E-6 / (xx + 5.0);
        return Math.log(2.5066282746310007 * ser) - tmp;
    }

    public static double lowerIncompleteGammaFunction(double a, double x) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("a must be > 0.0");
        }
        double gammp = x <= 0.0 ? 0.0 : (x > 1.0E10 ? 1.0 : (x < a + 1.0 ? MathUtil.incompleteGammaSeriesExpansion(a, x) : MathUtil.incompleteGammaContinuedFraction(a, x)));
        return gammp;
    }

    protected static double incompleteGammaSeriesExpansion(double a, double x) {
        int MAX_ITERATIONS = 1000;
        double EPS = 3.0E-7;
        double gamser = 0.0;
        if (x <= 0.0) {
            if (x < 0.0) {
                throw new IllegalArgumentException("x must be >= 0.0");
            }
            gamser = 0.0;
        } else {
            double sum;
            double gln = MathUtil.logGammaFunction(a);
            double ap = a;
            double del = sum = 1.0 / a;
            int n = 1;
            while (n <= 1000) {
                sum += (del *= x / (ap += 1.0));
                if (Math.abs(del) < Math.abs(sum) * 3.0E-7) {
                    gamser = sum * Math.exp(-x + a * Math.log(x) - gln);
                    break;
                }
                ++n;
            }
            if (n > 1000) {
                throw new OperationNotConvergedException("a too large, MAX_ITERATIONS too small in seriesExpansion()");
            }
        }
        return gamser;
    }

    public static double incompleteGammaContinuedFraction(double a, double x) {
        LentzMethod lentz = new LentzMethod();
        lentz.initializeAlgorithm(0.0);
        lentz.iterate(1.0, x + 1.0 - a);
        while (lentz.getKeepGoing()) {
            int i = lentz.getIteration();
            double aterm = (double)(-i) * ((double)i - a);
            double bterm = x + (double)(2 * i + 1) - a;
            lentz.iterate(aterm, bterm);
        }
        double gln = MathUtil.logGammaFunction(a);
        double gcf = lentz.getResult();
        double gamma = 1.0 - Math.exp(-x + a * Math.log(x) - gln) * gcf;
        return gamma;
    }

    public static int binomialCoefficient(int N, int k) {
        return (int)Math.round(Math.exp(MathUtil.logBinomialCoefficient(N, k)));
    }

    public static double logBinomialCoefficient(int N, int k) {
        return MathUtil.logFactorial(N) - MathUtil.logFactorial(k) - MathUtil.logFactorial(N - k);
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Factorial must be >= 0");
        }
        if (n <= 1) {
            return 0.0;
        }
        return MathUtil.logGammaFunction((double)n + 1.0);
    }

    public static double logBetaFunction(double a, double b) {
        double ga = MathUtil.logGammaFunction(a);
        double gb = MathUtil.logGammaFunction(b);
        double gab = MathUtil.logGammaFunction(a + b);
        return ga + gb - gab;
    }

    public static double regularizedIncompleteBetaFunction(double a, double b, double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("0 <= x <= 1");
        }
        double bt = x == 0.0 || x == 1.0 ? 0.0 : Math.exp(a * Math.log(x) + b * Math.log(1.0 - x) - MathUtil.logBetaFunction(a, b));
        if (x < (a + 1.0) / (a + b + 2.0)) {
            return bt * MathUtil.incompleteBetaContinuedFraction(a, b, x) / a;
        }
        return 1.0 - bt * MathUtil.incompleteBetaContinuedFraction(b, a, 1.0 - x) / b;
    }

    protected static double incompleteBetaContinuedFraction(double a, double b, double x) {
        double apb = a + b;
        LentzMethod lentz = new LentzMethod();
        lentz.initializeAlgorithm(0.0);
        lentz.iterate(1.0, 1.0);
        while (lentz.getKeepGoing()) {
            double aterm;
            double den;
            double num;
            int m = lentz.getIteration() / 2;
            double ap2m = a + (double)(2 * m);
            if (lentz.getIteration() % 2 != 0) {
                num = -(a + (double)m) * (apb + (double)m) * x;
                den = ap2m * (ap2m + 1.0);
                aterm = num / den;
            } else {
                num = (double)m * (b - (double)m) * x;
                den = (ap2m - 1.0) * ap2m;
                aterm = num / den;
            }
            lentz.iterate(aterm, 1.0);
        }
        if (lentz.isResultValid()) {
            return lentz.getResult();
        }
        throw new OperationNotConvergedException("Lentz's Method failed in Beta continuous fraction: " + String.format("a = %f, b = %f, x = %f", a, b, x));
    }

    public static double logMultinomialBetaFunction(Vector input) {
        double logsum = 0.0;
        double inputSum = 0.0;
        int i = 0;
        while (i < input.getDimensionality()) {
            double ai = input.getElement(i);
            inputSum += ai;
            logsum += MathUtil.logGammaFunction(ai);
            ++i;
        }
        return logsum -= MathUtil.logGammaFunction(inputSum);
    }

    public static int checkedAdd(int a, int b) throws ArithmeticException {
        if (a > 0 && b > Integer.MAX_VALUE - a) {
            throw new ArithmeticException("Integer Overflow: " + a + " + " + b + " > Integer.MAX_VALUE");
        }
        if (a < 0 && b < Integer.MIN_VALUE - a) {
            throw new ArithmeticException("Integer Underflow: " + a + " + " + b + " < Integer.MIN_VALUE");
        }
        return a + b;
    }

    public static int checkedMultiply(int a, int b) throws ArithmeticException {
        long result = (long)a * (long)b;
        int desiredHighBits = -((int)(result >>> 31) & 1);
        int actualHighBits = (int)(result >>> 32);
        if (desiredHighBits == actualHighBits) {
            return (int)result;
        }
        if (result > 0L) {
            throw new ArithmeticException("Integer Overflow: " + a + " * " + b + " > Integer.MAX_VALUE");
        }
        throw new ArithmeticException("Integer Underflow: " + a + " * " + b + " < Integer.MIN_VALUE");
    }

    public static double log1Plus(double x) {
        return Math.log1p(x);
    }

    public static double expMinus1Plus(double x) {
        return Math.expm1(x);
    }

    public static double log1MinusExp(double x) {
        if (x < 0.0 && x >= -LogMath.LOG_2) {
            return Math.log(-MathUtil.expMinus1Plus(x));
        }
        return Math.log1p(-Math.exp(x));
    }

    public static double log1PlusExp(double x) {
        if (x <= 18.0) {
            return Math.log1p(Math.exp(x));
        }
        if (x <= 33.3) {
            return x + Math.exp(-x);
        }
        return x;
    }
}

