/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math;

import gov.sandia.cognition.math.Ring;

public class RingAccumulator<RingType extends Ring<RingType>> {
    private int count;
    private RingType sum;

    public RingAccumulator() {
        this.clear();
    }

    public RingAccumulator(Iterable<? extends RingType> items) {
        this();
        this.accumulate(items);
    }

    public void clear() {
        this.setCount(0);
        this.setSum(null);
    }

    public void accumulate(RingType item) {
        if (item == null) {
            throw new NullPointerException("Cannot add null.");
        }
        this.setCount(this.getCount() + 1);
        if (this.sum == null) {
            this.setSum(item.clone());
        } else {
            this.sum.plusEquals(item);
        }
    }

    public void accumulate(Iterable<? extends RingType> items) {
        for (Ring item : items) {
            this.accumulate(item);
        }
    }

    public RingType scaleSum(double scaleFactor) {
        if (this.sum == null) {
            return null;
        }
        return this.sum.scale(scaleFactor);
    }

    public RingType getMean() {
        if (this.getCount() <= 0) {
            return null;
        }
        return this.scaleSum(1.0 / (double)this.count);
    }

    public RingType getSum() {
        return this.sum;
    }

    public int getCount() {
        return this.count;
    }

    private void setCount(int count) {
        this.count = count;
    }

    private void setSum(RingType sum) {
        this.sum = sum;
    }
}

