/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.AbstractRing;
import gov.sandia.cognition.math.RingAccumulator;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.AbstractList;
import java.util.List;

public abstract class AbstractMatrix
extends AbstractRing<Matrix>
implements Matrix {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof Matrix) {
            return this.equals((Matrix)other, 0.0);
        }
        return false;
    }

    @Override
    public boolean equals(Matrix other, double effectiveZero) {
        int M = this.getNumRows();
        int N = this.getNumColumns();
        if (M != other.getNumRows() || N != other.getNumColumns()) {
            return false;
        }
        int i = 0;
        while (i < M) {
            int j = 0;
            while (j < N) {
                double difference = this.getElement(i, j) - other.getElement(i, j);
                if (Math.abs(difference) > effectiveZero) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int numRows = this.getNumRows();
        int numColumns = this.getNumColumns();
        int result = 7 + numRows * numColumns;
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numColumns) {
                double value = this.getElement(i, j);
                if (value != 0.0) {
                    long bits = Double.doubleToLongBits(value);
                    result = 47 * result + i ^ j ^ (int)(bits ^ bits >>> 32);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean isSymmetric() {
        return this.isSymmetric(0.0);
    }

    @Override
    public boolean checkSameDimensions(Matrix otherMatrix) {
        return this.getNumRows() == otherMatrix.getNumRows() && this.getNumColumns() == otherMatrix.getNumColumns();
    }

    @Override
    public void assertSameDimensions(Matrix other) {
        if (!this.checkSameDimensions(other)) {
            throw new DimensionalityMismatchException("Matrices must have same dimensions: (" + this.getNumRows() + "x" + this.getNumColumns() + ") !=" + "(" + other.getNumRows() + "x" + other.getNumColumns() + ")");
        }
    }

    @Override
    public boolean checkMultiplicationDimensions(Matrix postMultiplicationMatrix) {
        return this.getNumColumns() == postMultiplicationMatrix.getNumRows();
    }

    @Override
    public Matrix dotDivide(Matrix other) {
        Matrix result = (Matrix)this.clone();
        result.dotDivideEquals(other);
        return result;
    }

    @Override
    public void dotDivideEquals(Matrix other) {
        this.assertSameDimensions(other);
        int rowCount = this.getNumRows();
        int columnCount = this.getNumColumns();
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < columnCount) {
                this.setElement(i, j, this.getElement(i, j) / other.getElement(i, j));
                ++j;
            }
            ++i;
        }
    }

    @Override
    public double trace() {
        int N;
        if (!this.isSquare()) {
            throw new DimensionalityMismatchException("Matrix must be square for trace()");
        }
        int M = this.getNumRows();
        int D = M < (N = this.getNumColumns()) ? M : N;
        double diagonal_sum = 0.0;
        int i = 0;
        while (i < D) {
            diagonal_sum += this.getElement(i, i);
            ++i;
        }
        return diagonal_sum;
    }

    @Override
    public void setSubMatrix(int minRow, int minColumn, Matrix submatrix) {
        int M = submatrix.getNumRows();
        int N = submatrix.getNumColumns();
        int i = 0;
        while (i < M) {
            int setRow = minRow + i;
            int j = 0;
            while (j < N) {
                double v = submatrix.getElement(i, j);
                this.setElement(setRow, minColumn + j, v);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int rank() {
        return this.rank(0.0);
    }

    @Override
    public Matrix pseudoInverse() {
        return this.pseudoInverse(0.0);
    }

    @Override
    public void setColumn(int columnIndex, Vector columnVector) {
        int M = this.getNumRows();
        if (M != columnVector.getDimensionality()) {
            throw new DimensionalityMismatchException(M, columnVector.getDimensionality());
        }
        int i = 0;
        while (i < M) {
            this.setElement(i, columnIndex, columnVector.getElement(i));
            ++i;
        }
    }

    @Override
    public void setRow(int rowIndex, Vector rowVector) {
        int N = this.getNumColumns();
        if (N != rowVector.getDimensionality()) {
            throw new DimensionalityMismatchException(N, rowVector.getDimensionality());
        }
        int j = 0;
        while (j < N) {
            this.setElement(rowIndex, j, rowVector.getElement(j));
            ++j;
        }
    }

    protected void getColumnInto(int columnIndex, Vector destinationVector) {
        int M = this.getNumRows();
        if (M != destinationVector.getDimensionality()) {
            throw new DimensionalityMismatchException(M, destinationVector.getDimensionality());
        }
        int i = 0;
        while (i < M) {
            destinationVector.setElement(i, this.getElement(i, columnIndex));
            ++i;
        }
    }

    protected void getRowInto(int rowIndex, Vector destinationVector) {
        int N = this.getNumColumns();
        if (N != destinationVector.getDimensionality()) {
            throw new DimensionalityMismatchException(N, destinationVector.getDimensionality());
        }
        int j = 0;
        while (j < N) {
            destinationVector.setElement(j, this.getElement(rowIndex, j));
            ++j;
        }
    }

    @Override
    public Vector sumOfRows() {
        RingAccumulator<Vector> accumulator = new RingAccumulator<Vector>();
        int numRows = this.getNumRows();
        int i = 0;
        while (i < numRows) {
            accumulator.accumulate(this.getRow(i));
            ++i;
        }
        return (Vector)accumulator.getSum();
    }

    @Override
    public Vector sumOfColumns() {
        RingAccumulator<Vector> accumulator = new RingAccumulator<Vector>();
        int numColumns = this.getNumColumns();
        int j = 0;
        while (j < numColumns) {
            accumulator.accumulate(this.getColumn(j));
            ++j;
        }
        return (Vector)accumulator.getSum();
    }

    @Override
    public boolean isZero(double effectiveZero) {
        for (MatrixEntry e : this) {
            if (!(Math.abs(e.getValue()) > effectiveZero)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void increment(int row, int column) {
        this.increment(row, column, 1.0);
    }

    @Override
    public void increment(int row, int column, double value) {
        this.setElement(row, column, this.getElement(row, column) + value);
    }

    @Override
    public void decrement(int row, int column) {
        this.decrement(row, column, 1.0);
    }

    @Override
    public void decrement(int row, int column, double value) {
        this.increment(row, column, -value);
    }

    @Override
    public double[][] toArray() {
        int rowCount = this.getNumRows();
        int columnCount = this.getNumColumns();
        double[][] result = new double[rowCount][columnCount];
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < columnCount) {
                result[i][j] = this.getElement(i, j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public List<Double> valuesAsList() {
        return new ValuesListView();
    }

    class ValuesListView
    extends AbstractList<Double> {
        private final int rowCount;
        private final int columnCount;
        private final int size;

        public ValuesListView() {
            this.rowCount = AbstractMatrix.this.getNumRows();
            this.columnCount = AbstractMatrix.this.getNumColumns();
            this.size = this.rowCount * this.columnCount;
        }

        @Override
        public Double get(int i) {
            int row = i % this.rowCount;
            int column = i / this.rowCount;
            return AbstractMatrix.this.getElement(row, column);
        }

        @Override
        public Double set(int i, Double value) {
            int row = i % this.rowCount;
            int column = i / this.rowCount;
            double previous = AbstractMatrix.this.getElement(row, column);
            AbstractMatrix.this.setElement(row, column, value);
            return previous;
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

