/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.AbstractVectorSpace;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.List;

public abstract class AbstractVector
extends AbstractVectorSpace<Vector, VectorEntry>
implements Vector {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_DELIMITER = " ";

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof Vector) {
            return this.equals((Vector)other, 0.0);
        }
        return false;
    }

    @Override
    public boolean equals(Vector other, double effectiveZero) {
        if (!this.checkSameDimensionality(other)) {
            return false;
        }
        return super.equals(other, effectiveZero);
    }

    public int hashCode() {
        int dimensionality = this.getDimensionality();
        int result = 7 + dimensionality;
        int i = 0;
        while (i < dimensionality) {
            double value = this.getElement(i);
            if (value != 0.0) {
                long bits = Double.doubleToLongBits(value);
                result = 47 * result + i ^ (int)(bits ^ bits >>> 32);
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean checkSameDimensionality(Vector other) {
        return this.getDimensionality() == other.getDimensionality();
    }

    @Override
    public void assertSameDimensionality(Vector other) {
        AbstractVector.assertEqualDimensionality(this, other);
    }

    @Override
    public void assertDimensionalityEquals(int otherDimensionality) {
        if (this.getDimensionality() != otherDimensionality) {
            throw new DimensionalityMismatchException(this.getDimensionality(), otherDimensionality);
        }
    }

    public static void assertEqualDimensionality(Vector first, Vector second) {
        first.assertDimensionalityEquals(second.getDimensionality());
    }

    @Override
    public Vector dotDivide(Vector other) {
        Vector result = (Vector)this.clone();
        result.dotDivideEquals(other);
        return result;
    }

    @Override
    public void dotDivideEquals(Vector other) {
        this.assertSameDimensionality(other);
        int dimensionality = this.getDimensionality();
        int i = 0;
        while (i < dimensionality) {
            this.setElement(i, this.getElement(i) / other.getElement(i));
            ++i;
        }
    }

    @Override
    public Vector transform(UnivariateScalarFunction function) {
        Vector result = (Vector)this.clone();
        result.transformEquals(function);
        return result;
    }

    @Override
    public Vector transform(Vector.IndexValueTransform function) {
        Vector result = (Vector)this.clone();
        result.transformEquals(function);
        return result;
    }

    @Override
    public void transformEquals(UnivariateScalarFunction function) {
        int dimensionality = this.getDimensionality();
        int i = 0;
        while (i < dimensionality) {
            double value = function.evaluate(this.get(i));
            this.set(i, value);
            ++i;
        }
    }

    @Override
    public void transformEquals(Vector.IndexValueTransform function) {
        int dimensionality = this.getDimensionality();
        int i = 0;
        while (i < dimensionality) {
            double value = function.transform(i, this.get(i));
            this.set(i, value);
            ++i;
        }
    }

    @Override
    public Vector transformNonZeros(UnivariateScalarFunction function) {
        Vector result = (Vector)this.clone();
        result.transformNonZerosEquals(function);
        return result;
    }

    @Override
    public Vector transformNonZeros(Vector.IndexValueTransform function) {
        Vector result = (Vector)this.clone();
        result.transformNonZerosEquals(function);
        return result;
    }

    @Override
    public void transformNonZerosEquals(UnivariateScalarFunction function) {
        for (VectorEntry entry : this) {
            double value = entry.getValue();
            if (value == 0.0) continue;
            entry.setValue(function.evaluate(value));
        }
    }

    @Override
    public void transformNonZerosEquals(Vector.IndexValueTransform function) {
        for (VectorEntry entry : this) {
            double value = entry.getValue();
            if (value == 0.0) continue;
            entry.setValue(function.transform(entry.getIndex(), value));
        }
    }

    @Override
    public void forEachElement(Vector.IndexValueConsumer consumer) {
        int dimensionality = this.getDimensionality();
        int i = 0;
        while (i < dimensionality) {
            consumer.consume(i, this.get(i));
            ++i;
        }
    }

    @Override
    public void forEachEntry(Vector.IndexValueConsumer consumer) {
        for (VectorEntry entry : this) {
            consumer.consume(entry.getIndex(), entry.getValue());
        }
    }

    @Override
    public void forEachNonZero(Vector.IndexValueConsumer consumer) {
        for (VectorEntry entry : this) {
            double value = entry.getValue();
            if (value == 0.0) continue;
            consumer.consume(entry.getIndex(), value);
        }
    }

    @Override
    public void increment(int index) {
        this.increment(index, 1.0);
    }

    @Override
    public void increment(int index, double value) {
        this.setElement(index, this.getElement(index) + value);
    }

    @Override
    public void decrement(int index) {
        this.decrement(index, 1.0);
    }

    @Override
    public void decrement(int index, double value) {
        this.increment(index, -value);
    }

    @Override
    public double[] toArray() {
        int dimensionality = this.getDimensionality();
        double[] result = new double[dimensionality];
        int i = 0;
        while (i < dimensionality) {
            result[i] = this.getElement(i);
            ++i;
        }
        return result;
    }

    @Override
    public List<Double> valuesAsList() {
        return new ValuesListView();
    }

    @Override
    public String toString() {
        int dimensionality = this.getDimensionality();
        StringBuilder builder = new StringBuilder(20 * dimensionality);
        int i = 0;
        while (i < dimensionality) {
            if (i > 0) {
                builder.append(DEFAULT_DELIMITER);
            }
            builder.append(this.getElement(i));
            ++i;
        }
        return builder.toString();
    }

    @Override
    public String toString(NumberFormat format) {
        return this.toString(format, DEFAULT_DELIMITER);
    }

    @Override
    public String toString(NumberFormat format, String delimiter) {
        int dimensionality = this.getDimensionality();
        StringBuilder builder = new StringBuilder(20 * dimensionality);
        int i = 0;
        while (i < dimensionality) {
            if (i > 0) {
                builder.append(delimiter);
            }
            builder.append(format.format(this.getElement(i)));
            ++i;
        }
        return builder.toString();
    }

    @Override
    public Vector convertToVector() {
        return this;
    }

    @Override
    public void convertFromVector(Vector parameters) {
        this.assertSameDimensionality(parameters);
        int dimensionality = this.getDimensionality();
        int i = 0;
        while (i < dimensionality) {
            this.setElement(i, parameters.getElement(i));
            ++i;
        }
    }

    class ValuesListView
    extends AbstractList<Double> {
        @Override
        public Double get(int i) {
            return AbstractVector.this.getElement(i);
        }

        @Override
        public Double set(int i, Double value) {
            double previous = AbstractVector.this.getElement(i);
            AbstractVector.this.setElement(i, value);
            return previous;
        }

        @Override
        public int size() {
            return AbstractVector.this.getDimensionality();
        }
    }
}

