/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.AbstractRing;
import gov.sandia.cognition.math.matrix.VectorSpace;
import gov.sandia.cognition.util.ArgumentChecker;

public abstract class AbstractVectorSpace<VectorType extends VectorSpace<VectorType, ? extends EntryType>, EntryType extends VectorSpace.Entry>
extends AbstractRing<VectorType>
implements VectorSpace<VectorType, EntryType> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof VectorSpace) {
            return this.equals((VectorType)((VectorSpace)other), 0.0);
        }
        return false;
    }

    @Override
    public double sum() {
        double sum = 0.0;
        for (VectorSpace.Entry entry : this) {
            sum += entry.getValue();
        }
        return sum;
    }

    @Override
    public double norm1() {
        double sum1 = 0.0;
        for (VectorSpace.Entry entry : this) {
            sum1 += Math.abs(entry.getValue());
        }
        return sum1;
    }

    @Override
    public double norm2() {
        return Math.sqrt(this.norm2Squared());
    }

    @Override
    public double norm2Squared() {
        double sum2 = 0.0;
        for (VectorSpace.Entry entry : this) {
            double value = entry.getValue();
            sum2 += value * value;
        }
        return sum2;
    }

    @Override
    public double normInfinity() {
        double max = 0.0;
        for (VectorSpace.Entry entry : this) {
            double value = Math.abs(entry.getValue());
            if (!(max < value)) continue;
            max = value;
        }
        return max;
    }

    @Override
    public double norm(double power) {
        ArgumentChecker.assertIsPositive("power", power);
        if (Double.isNaN(power)) {
            throw new ArithmeticException("Power cannot be NaN");
        }
        if (Double.isInfinite(power)) {
            return this.normInfinity();
        }
        double sum = 0.0;
        for (VectorSpace.Entry entry : this) {
            double value = Math.abs(entry.getValue());
            sum += Math.pow(value, power);
        }
        return Math.pow(sum, 1.0 / power);
    }

    @Override
    public double dot(VectorType other) {
        return this.dotProduct(other);
    }

    @Override
    public double angle(VectorType other) {
        double cosine = this.cosine(other);
        if (cosine > 1.0) {
            cosine = 1.0;
        } else if (cosine < -1.0) {
            cosine = -1.0;
        }
        return Math.acos(cosine);
    }

    @Override
    public double cosine(VectorType other) {
        double dotproduct = this.dotProduct(other);
        if (dotproduct == 0.0) {
            return 0.0;
        }
        double norm1 = this.norm2Squared();
        double norm2 = other.norm2Squared();
        return dotproduct / Math.sqrt(norm1 * norm2);
    }

    @Override
    public double euclideanDistance(VectorType other) {
        return Math.sqrt(this.euclideanDistanceSquared(other));
    }

    @Override
    public VectorType unitVector() {
        VectorSpace result = (VectorSpace)this.clone();
        result.unitVectorEquals();
        return (VectorType)result;
    }

    @Override
    public void unitVectorEquals() {
        double norm2 = this.norm2();
        if (norm2 != 0.0) {
            this.scaleEquals(1.0 / norm2);
        }
    }

    @Override
    public boolean isUnitVector() {
        return this.isUnitVector(0.0);
    }

    @Override
    public boolean isUnitVector(double tolerance) {
        return Math.abs(this.norm2() - 1.0) <= tolerance;
    }

    @Override
    public boolean equals(VectorType other, double effectiveZero) {
        return this.euclideanDistance(other) <= effectiveZero;
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        for (VectorSpace.Entry entry : this) {
            double value = entry.getValue();
            entry.setValue(value * scaleFactor);
        }
    }

    @Override
    public boolean isZero(double effectiveZero) {
        for (VectorSpace.Entry e : this) {
            if (!(e.getValue() > effectiveZero)) continue;
            return false;
        }
        return true;
    }
}

