/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;

public interface Matrix
extends Iterable<MatrixEntry>,
Ring<Matrix>,
Vectorizable,
Serializable {
    @Override
    public Matrix clone();

    public int getNumRows();

    public int getNumColumns();

    public double get(int var1, int var2);

    public void set(int var1, int var2, double var3);

    public double getElement(int var1, int var2);

    public void setElement(int var1, int var2, double var3);

    public Matrix getSubMatrix(int var1, int var2, int var3, int var4);

    public void setSubMatrix(int var1, int var2, Matrix var3);

    public boolean isSymmetric();

    public boolean isSymmetric(double var1);

    public boolean checkSameDimensions(Matrix var1);

    public void assertSameDimensions(Matrix var1);

    public boolean checkMultiplicationDimensions(Matrix var1);

    public Matrix times(Matrix var1);

    public Matrix transpose();

    public Matrix inverse();

    public Matrix pseudoInverse();

    public Matrix pseudoInverse(double var1);

    public Matrix dotDivide(Matrix var1);

    public void dotDivideEquals(Matrix var1);

    public ComplexNumber logDeterminant();

    public double trace();

    public int rank();

    public int rank(double var1);

    public double normFrobenius();

    public double normFrobeniusSquared();

    public boolean isSquare();

    public Matrix solve(Matrix var1);

    public Vector solve(Vector var1);

    public void identity();

    public Vector times(Vector var1);

    public boolean isSparse();

    public int getEntryCount();

    public Vector getColumn(int var1);

    public Vector getRow(int var1);

    public void setColumn(int var1, Vector var2);

    public void setRow(int var1, Vector var2);

    public Vector sumOfRows();

    public Vector sumOfColumns();

    public void increment(int var1, int var2);

    public void increment(int var1, int var2, double var3);

    public void decrement(int var1, int var2);

    public void decrement(int var1, int var2, double var3);

    @Override
    public void convertFromVector(Vector var1);

    @Override
    public Vector convertToVector();

    public double[][] toArray();

    public List<Double> valuesAsList();

    public String toString();

    public String toString(NumberFormat var1);
}

