/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorSpace;
import gov.sandia.cognition.math.matrix.Vectorizable;
import java.text.NumberFormat;
import java.util.List;

public interface Vector
extends VectorSpace<Vector, VectorEntry>,
Vectorizable {
    @Override
    public Vector clone();

    public int getDimensionality();

    public double get(int var1);

    public void set(int var1, double var2);

    public double getElement(int var1);

    public void setElement(int var1, double var2);

    public Matrix outerProduct(Vector var1);

    public Vector times(Matrix var1);

    public Vector dotDivide(Vector var1);

    public void dotDivideEquals(Vector var1);

    public boolean checkSameDimensionality(Vector var1);

    public void assertSameDimensionality(Vector var1);

    public void assertDimensionalityEquals(int var1);

    public Vector stack(Vector var1);

    public Vector subVector(int var1, int var2);

    public Vector transform(UnivariateScalarFunction var1);

    public Vector transform(IndexValueTransform var1);

    public void transformEquals(UnivariateScalarFunction var1);

    public void transformEquals(IndexValueTransform var1);

    public Vector transformNonZeros(UnivariateScalarFunction var1);

    public Vector transformNonZeros(IndexValueTransform var1);

    public void transformNonZerosEquals(UnivariateScalarFunction var1);

    public void transformNonZerosEquals(IndexValueTransform var1);

    public void forEachElement(IndexValueConsumer var1);

    public void forEachEntry(IndexValueConsumer var1);

    public void forEachNonZero(IndexValueConsumer var1);

    public void increment(int var1);

    public void increment(int var1, double var2);

    public void decrement(int var1);

    public void decrement(int var1, double var2);

    public boolean isSparse();

    public int getEntryCount();

    public double[] toArray();

    public List<Double> valuesAsList();

    public String toString();

    public String toString(NumberFormat var1);

    public String toString(NumberFormat var1, String var2);

    public static interface IndexValueConsumer {
        public void consume(int var1, double var2);
    }

    public static interface IndexValueTransform {
        public double transform(int var1, double var2);
    }
}

