/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vector1D;
import gov.sandia.cognition.math.matrix.Vector2D;
import gov.sandia.cognition.math.matrix.Vector3D;
import gov.sandia.cognition.math.matrix.mtj.DenseVectorFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseVectorFactoryMTJ;
import gov.sandia.cognition.util.ArgumentChecker;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Random;

public abstract class VectorFactory<VectorType extends Vector>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final VectorFactory<? extends Vector> DEFAULT_DENSE_INSTANCE = new DenseVectorFactoryMTJ();
    protected static final SparseVectorFactory<? extends Vector> DEFAULT_SPARSE_INSTANCE = new SparseVectorFactoryMTJ();

    protected VectorFactory() {
    }

    public static VectorFactory<? extends Vector> getDefault() {
        return DEFAULT_DENSE_INSTANCE;
    }

    public static VectorFactory<? extends Vector> getDenseDefault() {
        return DEFAULT_DENSE_INSTANCE;
    }

    public static SparseVectorFactory<? extends Vector> getSparseDefault() {
        return DEFAULT_SPARSE_INSTANCE;
    }

    public abstract VectorType copyVector(Vector var1);

    public VectorType copyArray(double[] values) {
        VectorType v = this.createVector(values.length);
        int i = 0;
        while (i < v.getDimensionality()) {
            double value = values[i];
            if (value != 0.0) {
                v.setElement(i, value);
            }
            ++i;
        }
        return v;
    }

    public VectorType copyValues(double ... values) {
        return this.copyArray(values);
    }

    public VectorType copyValues(Collection<? extends Number> values) {
        VectorType v = this.createVector(values.size());
        int index = 0;
        for (Number number : values) {
            v.set(index, number.doubleValue());
            ++index;
        }
        return v;
    }

    public abstract VectorType createVector(int var1);

    public Vector1D createVector1D() {
        return this.createVector1D(0.0);
    }

    public abstract Vector1D createVector1D(double var1);

    public Vector2D createVector2D() {
        return this.createVector2D(0.0, 0.0);
    }

    public abstract Vector2D createVector2D(double var1, double var3);

    public Vector3D createVector3D() {
        return this.createVector3D(0.0, 0.0, 0.0);
    }

    public abstract Vector3D createVector3D(double var1, double var3, double var5);

    public abstract VectorType createVectorCapacity(int var1, int var2);

    public VectorType createUniformRandom(int dim, double min, double max, Random random) {
        VectorType v = this.createVector(dim);
        int i = 0;
        while (i < v.getDimensionality()) {
            double uniform = random.nextDouble();
            double value = (max - min) * uniform + min;
            v.setElement(i, value);
            ++i;
        }
        return v;
    }

    public VectorType createVector(int dimensionality, double initialValue) {
        VectorType vector = this.createVector(dimensionality);
        if (initialValue != 0.0) {
            int i = 0;
            while (i < dimensionality) {
                vector.setElement(i, initialValue);
                ++i;
            }
        }
        return vector;
    }

    public VectorType copyArray(int dimensionality, int[] indices, double[] values) {
        int length = indices.length;
        if (length != values.length) {
            throw new IllegalArgumentException("indices and values must have the same length");
        }
        VectorType result = this.createVector(dimensionality);
        int i = 0;
        while (i < length) {
            double value = values[i];
            if (value != 0.0) {
                result.setElement(indices[i], value);
            }
            ++i;
        }
        return result;
    }

    public VectorType copyMap(int dimensionality, Map<Integer, ? extends Number> map) {
        ArgumentChecker.assertIsNotNull("map", map);
        VectorType result = this.createVectorCapacity(dimensionality, map.size());
        for (Map.Entry<Integer, ? extends Number> entry : map.entrySet()) {
            result.set(entry.getKey(), entry.getValue().doubleValue());
        }
        return result;
    }
}

