/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.matrix.DefaultTwoVectorEntry;
import gov.sandia.cognition.math.matrix.EntryIndexComparator;
import gov.sandia.cognition.math.matrix.TwoVectorEntry;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.VectorEntryIndexComparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VectorUnionIterator
implements Iterator<TwoVectorEntry> {
    private Iterator<VectorEntry> firstIterator;
    private Iterator<VectorEntry> secondIterator;
    private TwoVectorEntry internalEntry;
    private VectorEntry firstInternalEntry;
    private VectorEntry secondInternalEntry;

    public VectorUnionIterator(Vector first, Vector second) {
        this(first.iterator(), second.iterator(), new DefaultTwoVectorEntry(first, second));
    }

    public VectorUnionIterator(Iterator<VectorEntry> firstIterator, Iterator<VectorEntry> secondIterator, TwoVectorEntry internalEntry) {
        this.setFirstIterator(firstIterator);
        this.setSecondIterator(secondIterator);
        this.setInternalEntry(internalEntry);
        this.setFirstInternalEntry(null);
        this.setSecondInternalEntry(null);
    }

    protected void advanceInternalIterators() {
        boolean advanceFirst = false;
        boolean advanceSecond = false;
        EntryIndexComparator.Compare compare = VectorEntryIndexComparator.INSTANCE.lowestIndex(this.getFirstInternalEntry(), this.getSecondInternalEntry());
        if (compare == EntryIndexComparator.Compare.FIRST_LOWEST) {
            advanceFirst = true;
        } else if (compare == EntryIndexComparator.Compare.SECOND_LOWEST) {
            advanceSecond = true;
        } else if (compare == EntryIndexComparator.Compare.FIRST_ENTRY_NULL) {
            advanceSecond = true;
        } else if (compare == EntryIndexComparator.Compare.SECOND_ENTRY_NULL) {
            advanceFirst = true;
        } else if (compare == EntryIndexComparator.Compare.BOTH_ENTRIES_NULL) {
            advanceFirst = true;
            advanceSecond = true;
        } else if (compare == EntryIndexComparator.Compare.ENTRIES_EQUAL) {
            advanceFirst = true;
            advanceSecond = true;
        } else {
            throw new NoSuchElementException("Unknown Compare Enum: " + (Object)((Object)compare));
        }
        if (!advanceFirst && !advanceSecond) {
            throw new NoSuchElementException("Problem: Not advancing any iterators...");
        }
        if (advanceFirst) {
            this.safeFirstNext();
        }
        if (advanceSecond) {
            this.safeSecondNext();
        }
    }

    public boolean safeFirstNext() {
        boolean valid_next = false;
        try {
            if (this.getFirstIterator().hasNext()) {
                this.setFirstInternalEntry(this.getFirstIterator().next());
                valid_next = true;
            } else {
                this.setFirstInternalEntry(null);
            }
        }
        catch (Exception e) {
            this.setFirstInternalEntry(null);
        }
        return valid_next;
    }

    public boolean safeSecondNext() {
        boolean valid_next = false;
        try {
            if (this.getSecondIterator().hasNext()) {
                this.setSecondInternalEntry(this.getSecondIterator().next());
                valid_next = true;
            } else {
                this.setSecondInternalEntry(null);
            }
        }
        catch (Exception e) {
            this.setSecondInternalEntry(null);
        }
        return valid_next;
    }

    public Iterator<VectorEntry> getFirstIterator() {
        return this.firstIterator;
    }

    public void setFirstIterator(Iterator<VectorEntry> firstIterator) {
        this.firstIterator = firstIterator;
    }

    public Iterator<VectorEntry> getSecondIterator() {
        return this.secondIterator;
    }

    public void setSecondIterator(Iterator<VectorEntry> secondIterator) {
        this.secondIterator = secondIterator;
    }

    public TwoVectorEntry getInternalEntry() {
        return this.internalEntry;
    }

    public void setInternalEntry(TwoVectorEntry internalEntry) {
        this.internalEntry = internalEntry;
    }

    public VectorEntry getFirstInternalEntry() {
        return this.firstInternalEntry;
    }

    public void setFirstInternalEntry(VectorEntry firstInternalEntry) {
        this.firstInternalEntry = firstInternalEntry;
    }

    public VectorEntry getSecondInternalEntry() {
        return this.secondInternalEntry;
    }

    public void setSecondInternalEntry(VectorEntry secondInternalEntry) {
        this.secondInternalEntry = secondInternalEntry;
    }

    @Override
    public boolean hasNext() {
        return this.getFirstIterator().hasNext() || this.getSecondIterator().hasNext() || this.firstInternalEntry != null && this.secondInternalEntry != null && this.firstInternalEntry.getIndex() != this.secondInternalEntry.getIndex();
    }

    @Override
    public TwoVectorEntry next() {
        this.advanceInternalIterators();
        EntryIndexComparator.Compare compare = VectorEntryIndexComparator.INSTANCE.lowestIndex(this.getFirstInternalEntry(), this.getSecondInternalEntry());
        if (compare == EntryIndexComparator.Compare.ENTRIES_EQUAL) {
            this.getInternalEntry().setIndex(this.getFirstInternalEntry().getIndex());
        } else if (compare == EntryIndexComparator.Compare.FIRST_LOWEST) {
            this.getInternalEntry().setIndex(this.getFirstInternalEntry().getIndex());
        } else if (compare == EntryIndexComparator.Compare.SECOND_LOWEST) {
            this.getInternalEntry().setIndex(this.getSecondInternalEntry().getIndex());
        } else if (compare == EntryIndexComparator.Compare.FIRST_ENTRY_NULL) {
            this.getInternalEntry().setIndex(this.getSecondInternalEntry().getIndex());
        } else if (compare == EntryIndexComparator.Compare.SECOND_ENTRY_NULL) {
            this.getInternalEntry().setIndex(this.getFirstInternalEntry().getIndex());
        } else {
            throw new NoSuchElementException("No elements remaining.");
        }
        return this.getInternalEntry();
    }

    @Override
    public void remove() {
        this.getInternalEntry().setFirstValue(0.0);
        this.getInternalEntry().setSecondValue(0.0);
    }
}

