/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix;

import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;

public class VectorUtil {
    public static int safeGetDimensionality(Vectorizable vector) {
        if (vector == null) {
            return -1;
        }
        return VectorUtil.safeGetDimensionality(vector.convertToVector());
    }

    public static int safeGetDimensionality(Vector vector) {
        if (vector == null) {
            return -1;
        }
        return vector.getDimensionality();
    }

    public static Vector divideByNorm1(Vector input) {
        Vector clone = input.clone();
        VectorUtil.divideByNorm1Equals(clone);
        return clone;
    }

    public static void divideByNorm1Equals(Vector vector) {
        double norm1 = vector.norm1();
        if (norm1 != 0.0) {
            vector.scaleEquals(1.0 / norm1);
        }
    }

    public static Vector divideByNorm2(Vector input) {
        Vector clone = input.clone();
        VectorUtil.divideByNorm2Equals(clone);
        return clone;
    }

    public static void divideByNorm2Equals(Vector vector) {
        double norm2 = vector.norm2();
        if (norm2 != 0.0) {
            vector.scaleEquals(1.0 / norm2);
        }
    }

    public static Vector interpolateLinear(Vectorizable first, Vectorizable second, double percent) {
        return VectorUtil.interpolateLinear(first.convertToVector(), second.convertToVector(), percent);
    }

    public static Vector interpolateLinear(Vector first, Vector second, double percent) {
        if (percent <= 0.0) {
            return first.clone();
        }
        if (percent >= 1.0) {
            return second.clone();
        }
        Vector result = second.minus(first);
        result.scaleEquals(percent);
        result.plusEquals(first);
        return result;
    }

    public static void assertDimensionalitiesAllEqual(Iterable<? extends Vectorizable> data, int dimensionality) {
        if (data != null) {
            for (Vectorizable vectorizable : data) {
                Vector vector;
                if (vectorizable == null || (vector = vectorizable.convertToVector()) == null) continue;
                vector.assertDimensionalityEquals(dimensionality);
            }
        }
    }
}

