/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.decomposition;

import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.decomposition.EigenDecomposition;
import gov.sandia.cognition.util.ArrayIndexSorter;

public abstract class AbstractEigenDecomposition
implements EigenDecomposition {
    private ComplexNumber[] eigenValues;
    private Matrix eigenVectorsRealPart;
    private Matrix eigenVectorsImaginaryPart;

    protected AbstractEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart) {
        this.setEigenValues(eigenValues);
        this.setEigenVectorsRealPart(eigenVectorsRealPart);
        this.setEigenVectorsImaginaryPart(eigenVectorsImaginaryPart);
    }

    protected AbstractEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart, boolean sort) {
        this.setEigenDecomposition(eigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart, sort);
    }

    protected void setEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart, boolean sort) {
        if (sort) {
            this.sortAndSetEigenDecomposition(eigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart);
        } else {
            this.setUnsortedEigenDecomposition(eigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart);
        }
    }

    protected void sortAndSetEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart) {
        int M = eigenValues.length;
        double[] magnitudes = new double[M];
        int i = 0;
        while (i < M) {
            magnitudes[i] = eigenValues[i].getMagnitude();
            ++i;
        }
        int[] indices = ArrayIndexSorter.sortArrayDescending(magnitudes);
        ComplexNumber[] sortedEigenValues = new ComplexNumber[M];
        Matrix sortedEigenVectorsRealPart = eigenVectorsRealPart.clone();
        Matrix sortedEigenVectorsImaginaryPart = eigenVectorsImaginaryPart.clone();
        int j = 0;
        while (j < M) {
            sortedEigenValues[j] = eigenValues[indices[j]];
            int i2 = 0;
            while (i2 < M) {
                sortedEigenVectorsRealPart.setElement(i2, j, eigenVectorsRealPart.getElement(i2, indices[j]));
                sortedEigenVectorsImaginaryPart.setElement(i2, j, eigenVectorsImaginaryPart.getElement(i2, indices[j]));
                ++i2;
            }
            ++j;
        }
        this.setUnsortedEigenDecomposition(sortedEigenValues, sortedEigenVectorsRealPart, sortedEigenVectorsImaginaryPart);
    }

    protected void setUnsortedEigenDecomposition(ComplexNumber[] eigenValues, Matrix eigenVectorsRealPart, Matrix eigenVectorsImaginaryPart) {
        this.setEigenValues(eigenValues);
        this.setEigenVectorsRealPart(eigenVectorsRealPart);
        this.setEigenVectorsImaginaryPart(eigenVectorsImaginaryPart);
    }

    @Override
    public ComplexNumber[] getEigenValues() {
        return this.eigenValues;
    }

    protected void setEigenValues(ComplexNumber[] eigenValues) {
        this.eigenValues = eigenValues;
    }

    @Override
    public ComplexNumber getEigenValue(int index) {
        return this.getEigenValues()[index];
    }

    @Override
    public Matrix getEigenVectorsRealPart() {
        return this.eigenVectorsRealPart;
    }

    protected void setEigenVectorsRealPart(Matrix eigenVectorsRealPart) {
        this.eigenVectorsRealPart = eigenVectorsRealPart;
    }

    @Override
    public Matrix getEigenVectorsImaginaryPart() {
        return this.eigenVectorsImaginaryPart;
    }

    public void setEigenVectorsImaginaryPart(Matrix eigenVectorsImaginaryPart) {
        this.eigenVectorsImaginaryPart = eigenVectorsImaginaryPart;
    }

    @Override
    public ComplexNumber getLogDeterminant() {
        ComplexNumber[] eigenvalues;
        ComplexNumber logsum = new ComplexNumber(0.0, 0.0);
        ComplexNumber[] complexNumberArray = eigenvalues = this.getEigenValues();
        int n = eigenvalues.length;
        int n2 = 0;
        while (n2 < n) {
            ComplexNumber c = complexNumberArray[n2];
            logsum.plusEquals(c.computeNaturalLogarithm());
            ++n2;
        }
        return logsum;
    }
}

