/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.decomposition;

import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.OperationNotConvergedException;
import gov.sandia.cognition.math.matrix.decomposition.AbstractEigenDecomposition;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import no.uib.cipr.matrix.EVD;
import no.uib.cipr.matrix.NotConvergedException;

public class EigenDecompositionRightMTJ
extends AbstractEigenDecomposition {
    private EigenDecompositionRightMTJ(DenseMatrix matrix) throws OperationNotConvergedException {
        super(null, null, null);
        boolean leftEVD = false;
        boolean rightEVD = true;
        EVD mtjEVD = new EVD(matrix.getNumRows(), leftEVD, rightEVD);
        try {
            mtjEVD.factor(new no.uib.cipr.matrix.DenseMatrix(matrix.getInternalMatrix()));
        }
        catch (NotConvergedException e) {
            throw new OperationNotConvergedException(e.getMessage());
        }
        int numEigenValues = matrix.getNumRows();
        ComplexNumber[] unsortedEigenValues = new ComplexNumber[numEigenValues];
        DenseMatrixFactoryMTJ matrixFactory = DenseMatrixFactoryMTJ.INSTANCE;
        DenseMatrix lapackEigenVectors = matrixFactory.createWrapper(mtjEVD.getRightEigenvectors());
        DenseMatrix eigenVectorsRealPart = matrixFactory.createMatrix(numEigenValues, numEigenValues);
        DenseMatrix eigenVectorsImaginaryPart = matrixFactory.createMatrix(numEigenValues, numEigenValues);
        double[] realEigenValues = mtjEVD.getRealEigenvalues();
        double[] imaginaryEigenValues = mtjEVD.getImaginaryEigenvalues();
        boolean firstComplexConjugateDone = false;
        ComplexNumber[] complexEigenVector = new ComplexNumber[numEigenValues];
        int j = 0;
        while (j < numEigenValues) {
            int i;
            unsortedEigenValues[j] = new ComplexNumber(realEigenValues[j], imaginaryEigenValues[j]);
            if (unsortedEigenValues[j].getImaginaryPart() != 0.0) {
                if (!firstComplexConjugateDone) {
                    firstComplexConjugateDone = true;
                    i = 0;
                    while (i < numEigenValues) {
                        complexEigenVector[i] = new ComplexNumber(lapackEigenVectors.getElement(i, j), lapackEigenVectors.getElement(i, j + 1));
                        ++i;
                    }
                } else {
                    firstComplexConjugateDone = false;
                    i = 0;
                    while (i < numEigenValues) {
                        complexEigenVector[i] = new ComplexNumber(lapackEigenVectors.getElement(i, j - 1), -lapackEigenVectors.getElement(i, j));
                        ++i;
                    }
                }
            } else {
                firstComplexConjugateDone = false;
                i = 0;
                while (i < numEigenValues) {
                    complexEigenVector[i] = new ComplexNumber(lapackEigenVectors.getElement(i, j), 0.0);
                    ++i;
                }
            }
            i = 0;
            while (i < numEigenValues) {
                eigenVectorsRealPart.setElement(i, j, complexEigenVector[i].getRealPart());
                eigenVectorsImaginaryPart.setElement(i, j, complexEigenVector[i].getImaginaryPart());
                ++i;
            }
            ++j;
        }
        this.setEigenDecomposition(unsortedEigenValues, eigenVectorsRealPart, eigenVectorsImaginaryPart, true);
    }

    public static EigenDecompositionRightMTJ create(DenseMatrix matrix) throws OperationNotConvergedException {
        return new EigenDecompositionRightMTJ(matrix);
    }
}

