/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.decomposition;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.ArrayList;

public class EigenvectorPowerIteration
extends AbstractCloneableSerializable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_STOPPING_THRESHOLD = 1.0E-5;
    public static final int DEFAULT_MAXIMUM_ITERATIONS = 100;

    public static ArrayList<Vector> estimateEigenvectors(Matrix A, int numEigenvectors) {
        return EigenvectorPowerIteration.estimateEigenvectors(A, numEigenvectors, 1.0E-5, 100);
    }

    public static ArrayList<Vector> estimateEigenvectors(Matrix A, int numEigenvectors, double stoppingThreshold, int maxIterations) {
        if (!A.isSymmetric(stoppingThreshold)) {
            throw new IllegalArgumentException("Matrix must be symmetric to compute eigenvectors.");
        }
        int M = A.getNumRows();
        if (numEigenvectors < 0 || numEigenvectors > M) {
            throw new IllegalArgumentException("The number of eigenvectors must be between 1 and the size of the matrix.");
        }
        ArrayList<Vector> eigenvectors = new ArrayList<Vector>(numEigenvectors);
        int i = 0;
        while (i < numEigenvectors) {
            Vector ui = VectorFactory.getDefault().createVector(M, 1.0);
            Vector ei = EigenvectorPowerIteration.estimateEigenvector(ui, A, stoppingThreshold, maxIterations);
            eigenvectors.add(ei);
            if (i < numEigenvectors - 1) {
                double eigenvalue = EigenvectorPowerIteration.estimateEigenvalue(A, ei);
                Matrix B = ((Vector)ei.scale(eigenvalue)).outerProduct(ei);
                A.minusEquals(B);
            }
            ++i;
        }
        return eigenvectors;
    }

    public static Vector estimateEigenvector(Vector initial, Matrix A, double stoppingThreshold, int maxIterations) {
        Vector v = (Vector)initial.unitVector();
        int iteration = 0;
        boolean keepGoing = true;
        while (keepGoing) {
            Vector vPrevious = v;
            v = A.times(v);
            v.unitVectorEquals();
            double normChange = v.minus(vPrevious).norm2();
            if (!(normChange <= stoppingThreshold) && ++iteration < maxIterations) continue;
            keepGoing = false;
        }
        return v;
    }

    public static double estimateEigenvalue(Matrix A, Vector v) {
        Vector vunit = (Vector)v.unitVector();
        Vector vlambda = A.times(vunit);
        double lambda = vlambda.norm2();
        if (lambda != 0.0) {
            Vector vunithat = (Vector)vlambda.scale(1.0 / lambda);
            double dp = vunithat.minus(vunit).norm2();
            double dn = vunithat.plus(vunit).norm2();
            if (dn < dp) {
                lambda *= -1.0;
            }
        }
        return lambda;
    }
}

