/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.matrix.AbstractMatrix;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.TwoMatrixEntry;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import gov.sandia.cognition.math.matrix.mtj.MatrixUnionIteratorMTJ;
import gov.sandia.cognition.math.matrix.mtj.decomposition.EigenDecompositionRightMTJ;
import gov.sandia.cognition.math.matrix.mtj.decomposition.SingularValueDecompositionMTJ;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.QR;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

public abstract class AbstractMTJMatrix
extends AbstractMatrix {
    private static final long serialVersionUID = 1L;
    private transient no.uib.cipr.matrix.Matrix internalMatrix;

    protected AbstractMTJMatrix(no.uib.cipr.matrix.Matrix internalMatrix) {
        this.setInternalMatrix(internalMatrix);
    }

    @Override
    public AbstractMTJMatrix clone() {
        AbstractMTJMatrix clone = (AbstractMTJMatrix)super.clone();
        clone.setInternalMatrix(this.getInternalMatrix().copy());
        return clone;
    }

    public no.uib.cipr.matrix.Matrix getInternalMatrix() {
        return this.internalMatrix;
    }

    protected void setInternalMatrix(no.uib.cipr.matrix.Matrix internalMatrix) {
        if (internalMatrix == null) {
            throw new IllegalArgumentException("internalMatrix cannot be null!");
        }
        this.internalMatrix = internalMatrix;
    }

    @Override
    public int getNumRows() {
        return this.internalMatrix.numRows();
    }

    @Override
    public int getNumColumns() {
        return this.internalMatrix.numColumns();
    }

    @Override
    public double get(int rowIndex, int columnIndex) {
        return this.internalMatrix.get(rowIndex, columnIndex);
    }

    @Override
    public void set(int rowIndex, int columnIndex, double value) {
        this.internalMatrix.set(rowIndex, columnIndex, value);
    }

    @Override
    public double getElement(int rowIndex, int columnIndex) {
        return this.internalMatrix.get(rowIndex, columnIndex);
    }

    @Override
    public void setElement(int rowIndex, int columnIndex, double value) {
        this.internalMatrix.set(rowIndex, columnIndex, value);
    }

    @Override
    public ComplexNumber logDeterminant() {
        int sign;
        UpperTriangDenseMatrix triangularMatrix;
        Object decomposition;
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Matrix must be square");
        }
        DenseMatrix decompositionMatrix = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        boolean useEVD = false;
        if (useEVD) {
            EigenDecompositionRightMTJ evd = EigenDecompositionRightMTJ.create(decompositionMatrix);
            return evd.getLogDeterminant();
        }
        boolean useQR = false;
        if (useQR) {
            decomposition = QR.factorize(this.internalMatrix);
            triangularMatrix = ((QR)decomposition).getR();
            sign = 1;
        } else {
            decomposition = DenseLU.factorize(this.internalMatrix);
            triangularMatrix = ((DenseLU)decomposition).getU();
            sign = 1;
            int i = 0;
            while (i < ((DenseLU)decomposition).getPivots().length) {
                if (((DenseLU)decomposition).getPivots()[i] != i + 1) {
                    sign = -sign;
                }
                ++i;
            }
        }
        int M = triangularMatrix.numRows();
        int N = triangularMatrix.numColumns();
        int maxIndex = M < N ? M : N;
        double logsum = 0.0;
        int i = 0;
        while (i < maxIndex) {
            double eigenvalue = triangularMatrix.get(i, i);
            if (eigenvalue < 0.0) {
                sign = -sign;
                logsum += Math.log(-eigenvalue);
            } else {
                logsum += Math.log(eigenvalue);
            }
            ++i;
        }
        return new ComplexNumber(logsum, sign < 0 ? Math.PI : 0.0);
    }

    @Override
    public boolean equals(AbstractMTJMatrix matrix, double effectiveZero) {
        MatrixUnionIteratorMTJ iterator = new MatrixUnionIteratorMTJ(this, matrix);
        while (iterator.hasNext()) {
            TwoMatrixEntry entry = iterator.next();
            double diff = entry.getFirstValue() - entry.getSecondValue();
            if (!(Math.abs(diff) > effectiveZero)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plusEquals(Matrix matrix) {
        this.plusEquals((AbstractMTJMatrix)matrix);
    }

    @Override
    public void plusEquals(AbstractMTJMatrix matrix) {
        this.internalMatrix.add(matrix.internalMatrix);
    }

    @Override
    public void minusEquals(Matrix matrix) {
        this.minusEquals((AbstractMTJMatrix)matrix);
    }

    @Override
    public void minusEquals(AbstractMTJMatrix matrix) {
        double additionScaleFactor = -1.0;
        this.internalMatrix.add(additionScaleFactor, matrix.internalMatrix);
    }

    @Override
    public AbstractMTJMatrix times(Matrix matrix) {
        return this.times((AbstractMTJMatrix)matrix);
    }

    public abstract AbstractMTJMatrix times(AbstractMTJMatrix var1);

    @Override
    public void dotTimesEquals(Matrix matrix) {
        this.dotTimesEquals((AbstractMTJMatrix)matrix);
    }

    @Override
    public void dotTimesEquals(AbstractMTJMatrix matrix) {
        this.assertSameDimensions(matrix);
        for (MatrixEntry e : this) {
            double otherValue = matrix.getElement(e.getRowIndex(), e.getColumnIndex());
            e.setValue(e.getValue() * otherValue);
        }
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        for (MatrixEntry e : this) {
            e.setValue(e.getValue() * scaleFactor);
        }
    }

    @Override
    public void scaledPlusEquals(double scaleFactor, Matrix other) {
        this.scaledPlusEquals(scaleFactor, (AbstractMTJMatrix)other);
    }

    @Override
    public void scaledPlusEquals(double scaleFactor, AbstractMTJMatrix other) {
        this.internalMatrix.add(scaleFactor, other.internalMatrix);
    }

    @Override
    public void scaledMinusEquals(double scaleFactor, AbstractMTJMatrix other) {
        this.scaledPlusEquals(-scaleFactor, other);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new AbstractMTJMatrixIterator();
    }

    @Override
    public boolean isSquare() {
        return this.getNumRows() == this.getNumColumns();
    }

    @Override
    public AbstractMTJVector times(Vector vector) {
        return this.times((AbstractMTJVector)vector);
    }

    public abstract AbstractMTJVector times(AbstractMTJVector var1);

    @Override
    public void identity() {
        this.internalMatrix.zero();
        int N = this.getNumRows() < this.getNumColumns() ? this.getNumRows() : this.getNumColumns();
        int i = 0;
        while (i < N) {
            this.setElement(i, i, 1.0);
            ++i;
        }
    }

    @Override
    public Matrix solve(Matrix B) {
        return this.solve((AbstractMTJMatrix)B);
    }

    @Override
    public Vector solve(Vector b) {
        return this.solve((AbstractMTJVector)b);
    }

    public final Matrix solve(AbstractMTJMatrix B) {
        DenseMatrix X = new DenseMatrix(this.getNumColumns(), B.getNumColumns());
        DenseMatrix Bdense = B instanceof DenseMatrix ? (DenseMatrix)B : new DenseMatrix(B);
        DenseMatrix Adense = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        boolean usePseudoInverse = false;
        try {
            Adense.solveInto(Bdense, X);
            usePseudoInverse = false;
        }
        catch (MatrixSingularException e) {
            Logger.getLogger(AbstractMTJMatrix.class.getName()).log(Level.WARNING, "AbstractMTJMatrix.solve(): Matrix is singular.");
            usePseudoInverse = true;
        }
        if (!usePseudoInverse) {
            int i = 0;
            while (i < X.getNumRows()) {
                int j = 0;
                while (j < X.getNumColumns()) {
                    double v = X.getElement(i, j);
                    if (Double.isNaN(v) || Double.isInfinite(v)) {
                        Logger.getLogger(AbstractMTJMatrix.class.getName()).log(Level.WARNING, "AbstractMTJMatrix.solve(): Solver produced invalid results.");
                        usePseudoInverse = true;
                        break;
                    }
                    ++j;
                }
                if (usePseudoInverse) break;
                ++i;
            }
        }
        if (usePseudoInverse) {
            return Adense.pseudoInverse().times(Bdense);
        }
        return X;
    }

    public Vector solve(AbstractMTJVector b) {
        DenseVector x = new DenseVector(this.getNumColumns());
        DenseVector bdense = b instanceof DenseVector ? (DenseVector)b : new DenseVector(b);
        DenseMatrix Adense = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        boolean usePseudoInverse = false;
        try {
            Adense.solveInto(bdense, x);
            usePseudoInverse = false;
        }
        catch (MatrixSingularException e) {
            Logger.getLogger(AbstractMTJMatrix.class.getName()).log(Level.WARNING, "AbstractMTJMatrix.solve(): Matrix is singular.");
            usePseudoInverse = true;
        }
        if (!usePseudoInverse) {
            int i = 0;
            while (i < x.getDimensionality()) {
                double v = x.getElement(i);
                if (Double.isNaN(v) || Double.isInfinite(v)) {
                    Logger.getLogger(AbstractMTJMatrix.class.getName()).log(Level.WARNING, "AbstractMTJMatrix.solve(): Solver produced invalid results.");
                    usePseudoInverse = true;
                    break;
                }
                ++i;
            }
        }
        if (usePseudoInverse) {
            return Adense.pseudoInverse().times(b);
        }
        return x;
    }

    @Override
    public Matrix inverse() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("Can only invert square matrices.");
        }
        DenseMatrix I = (DenseMatrix)DenseMatrixFactoryMTJ.INSTANCE.createIdentity(this.getNumRows(), this.getNumColumns());
        Matrix AI = this.solve(I);
        return AI;
    }

    @Override
    public double normFrobenius() {
        return this.internalMatrix.norm(Matrix.Norm.Frobenius);
    }

    @Override
    public double normFrobeniusSquared() {
        double normFrobenius = this.normFrobenius();
        return normFrobenius * normFrobenius;
    }

    @Override
    public boolean isSymmetric(double effectiveZero) {
        if (!this.isSquare()) {
            throw new DimensionalityMismatchException(this.getNumRows(), this.getNumColumns());
        }
        int i = 0;
        while (i < this.getNumRows()) {
            int j = i + 1;
            while (j < this.getNumColumns()) {
                double difference = this.getElement(i, j) - this.getElement(j, i);
                if (Math.abs(difference) > effectiveZero) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void zero() {
        this.internalMatrix.zero();
    }

    @Override
    public int rank(double effectiveZero) {
        DenseMatrix svdDude = this instanceof DenseMatrix ? (DenseMatrix)this : new DenseMatrix(this);
        SingularValueDecompositionMTJ svd = SingularValueDecompositionMTJ.create(svdDude);
        return svd.effectiveRank(effectiveZero);
    }

    protected void transposeInto(AbstractMTJMatrix destinationMatrix) {
        this.internalMatrix.transpose(destinationMatrix.internalMatrix);
    }

    protected void getSubMatrixInto(int minRow, int maxRow, int minColumn, int maxColumn, AbstractMTJMatrix destinationMatrix) {
        if (destinationMatrix.getNumRows() != maxRow - minRow + 1 || destinationMatrix.getNumColumns() != maxColumn - minColumn + 1) {
            throw new DimensionalityMismatchException("Submatrix is incorrect size.");
        }
        int i = minRow;
        while (i <= maxRow) {
            int j = minColumn;
            while (j <= maxColumn) {
                destinationMatrix.setElement(i - minRow, j - minColumn, this.getElement(i, j));
                ++j;
            }
            ++i;
        }
    }

    protected void timesInto(AbstractMTJMatrix multiplicationMatrix, AbstractMTJMatrix destinationMatrix) {
        int M = this.getNumRows();
        int N = multiplicationMatrix.getNumColumns();
        if (M != destinationMatrix.getNumRows() || N != destinationMatrix.getNumColumns()) {
            throw new DimensionalityMismatchException("Multiplication dimensions do not agree.");
        }
        this.internalMatrix.mult(multiplicationMatrix.internalMatrix, destinationMatrix.internalMatrix);
    }

    protected void timesInto(AbstractMTJVector multiplicationVector, AbstractMTJVector destinationVector) {
        int M = this.getNumRows();
        if (M != destinationVector.getDimensionality()) {
            throw new DimensionalityMismatchException(M, destinationVector.getDimensionality());
        }
        this.internalMatrix.mult(multiplicationVector.getInternalVector(), destinationVector.getInternalVector());
    }

    @Override
    public void increment(int row, int column, double value) {
        this.internalMatrix.add(row, column, value);
    }

    @Override
    public void convertFromVector(Vector parameters) {
        int N;
        int M = this.getNumRows();
        if (M * (N = this.getNumColumns()) != parameters.getDimensionality()) {
            throw new IllegalArgumentException("Elements in this does not equal elements in parameters");
        }
        int index = 0;
        int j = 0;
        while (j < N) {
            int i = 0;
            while (i < M) {
                this.setElement(i, j, parameters.getElement(index));
                ++index;
                ++i;
            }
            ++j;
        }
    }

    @Override
    public DenseVector convertToVector() {
        int M = this.getNumRows();
        int N = this.getNumColumns();
        DenseVector parameters = new DenseVector(M * N);
        int index = 0;
        int j = 0;
        while (j < N) {
            int i = 0;
            while (i < M) {
                parameters.setElement(index, this.getElement(i, j));
                ++index;
                ++i;
            }
            ++j;
        }
        return parameters;
    }

    class AbstractMTJMatrixEntry
    implements MatrixEntry {
        private int rowIndex;
        private int columnIndex;

        AbstractMTJMatrixEntry() {
            this(0, 0);
        }

        AbstractMTJMatrixEntry(int rowIndex, int columnIndex) {
            this.setRowIndex(rowIndex);
            this.setColumnIndex(columnIndex);
        }

        @Override
        public double getValue() {
            return AbstractMTJMatrix.this.getElement(this.getRowIndex(), this.getColumnIndex());
        }

        @Override
        public void setValue(double value) {
            AbstractMTJMatrix.this.setElement(this.getRowIndex(), this.getColumnIndex(), value);
        }

        @Override
        public int getRowIndex() {
            return this.rowIndex;
        }

        @Override
        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public int getColumnIndex() {
            return this.columnIndex;
        }

        @Override
        public void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }
    }

    class AbstractMTJMatrixIterator
    implements Iterator<MatrixEntry> {
        private Iterator<no.uib.cipr.matrix.MatrixEntry> internalIterator;
        private MatrixEntry entry = null;

        public AbstractMTJMatrixIterator() {
            this.setInternalIterator(AbstractMTJMatrix.this.internalMatrix.iterator());
            this.setEntry(new AbstractMTJMatrixEntry());
        }

        protected Iterator<no.uib.cipr.matrix.MatrixEntry> getInternalIterator() {
            return this.internalIterator;
        }

        protected void setInternalIterator(Iterator<no.uib.cipr.matrix.MatrixEntry> internalIterator) {
            this.internalIterator = internalIterator;
        }

        @Override
        public boolean hasNext() {
            return this.getInternalIterator().hasNext();
        }

        @Override
        public MatrixEntry next() {
            no.uib.cipr.matrix.MatrixEntry internalNext = this.getInternalIterator().next();
            this.getEntry().setRowIndex(internalNext.row());
            this.getEntry().setColumnIndex(internalNext.column());
            return this.getEntry();
        }

        @Override
        public void remove() {
            this.getInternalIterator().remove();
        }

        public MatrixEntry getEntry() {
            return this.entry;
        }

        public void setEntry(MatrixEntry entry) {
            this.entry = entry;
        }
    }
}

