/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.matrix.AbstractVector;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.io.Serializable;
import java.util.Iterator;
import no.uib.cipr.matrix.Vector;

public abstract class AbstractMTJVector
extends AbstractVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient no.uib.cipr.matrix.Vector internalVector;

    protected AbstractMTJVector(no.uib.cipr.matrix.Vector internalVector) {
        this.internalVector = internalVector;
    }

    @Override
    public AbstractMTJVector clone() {
        AbstractMTJVector clone = (AbstractMTJVector)super.clone();
        clone.setInternalVector(this.getInternalVector().copy());
        return clone;
    }

    @Override
    public int getDimensionality() {
        return this.internalVector.size();
    }

    @Override
    public double get(int index) {
        return this.internalVector.get(index);
    }

    @Override
    public void set(int index, double value) {
        this.internalVector.set(index, value);
    }

    @Override
    public double getElement(int index) {
        return this.internalVector.get(index);
    }

    @Override
    public void setElement(int index, double value) {
        this.internalVector.set(index, value);
    }

    @Override
    public void increment(int index, double value) {
        this.internalVector.add(index, value);
    }

    @Override
    public Vector times(Matrix matrix) {
        return this.times((AbstractMTJMatrix)matrix);
    }

    public Vector times(AbstractMTJMatrix matrix) {
        int N = matrix.getNumColumns();
        DenseVector retval = new DenseVector(N);
        matrix.getInternalMatrix().transMult(this.getInternalVector(), retval.getInternalVector());
        return retval;
    }

    protected no.uib.cipr.matrix.Vector getInternalVector() {
        return this.internalVector;
    }

    protected void setInternalVector(no.uib.cipr.matrix.Vector internalVector) {
        this.internalVector = internalVector;
    }

    @Override
    public double norm2() {
        return this.internalVector.norm(Vector.Norm.Two);
    }

    @Override
    public double norm2Squared() {
        double norm = this.norm2();
        return norm * norm;
    }

    @Override
    public void plusEquals(Vector other) {
        this.plusEquals((AbstractMTJVector)other);
    }

    @Override
    public void plusEquals(AbstractMTJVector other) {
        this.internalVector.add(other.internalVector);
    }

    @Override
    public void minusEquals(Vector other) {
        this.minusEquals((AbstractMTJVector)other);
    }

    @Override
    public void minusEquals(AbstractMTJVector other) {
        this.internalVector.add(-1.0, other.internalVector);
    }

    @Override
    public double dotProduct(Vector other) {
        return this.dotProduct((AbstractMTJVector)other);
    }

    @Override
    public double dotProduct(AbstractMTJVector other) {
        this.assertSameDimensionality(other);
        return this.internalVector.dot(other.internalVector);
    }

    @Override
    public void dotTimesEquals(Vector other) {
        for (VectorEntry entry : this) {
            entry.setValue(entry.getValue() * other.getElement(entry.getIndex()));
        }
    }

    @Override
    public void scaleEquals(double scaleFactor) {
        this.internalVector.scale(scaleFactor);
    }

    @Override
    public void scaledPlusEquals(double scaleFactor, Vector other) {
        this.scaledPlusEquals(scaleFactor, (AbstractMTJVector)other);
    }

    @Override
    public void scaledPlusEquals(double scaleFactor, AbstractMTJVector other) {
        this.internalVector.add(scaleFactor, other.internalVector);
    }

    @Override
    public void scaledMinusEquals(double scaleFactor, AbstractMTJVector other) {
        this.scaledPlusEquals(-scaleFactor, other);
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new AbstractMTJVectorIterator();
    }

    @Override
    public void zero() {
        this.internalVector.zero();
    }

    @Override
    public AbstractMTJMatrix outerProduct(Vector other) {
        return this.outerProduct((AbstractMTJVector)other);
    }

    public abstract AbstractMTJMatrix outerProduct(AbstractMTJVector var1);

    private static final class AbstractMTJVectorEntry
    extends AbstractCloneableSerializable
    implements VectorEntry {
        private static final long serialVersionUID = 1L;
        private no.uib.cipr.matrix.VectorEntry internalEntry;

        public AbstractMTJVectorEntry() {
            this(null);
        }

        public AbstractMTJVectorEntry(no.uib.cipr.matrix.VectorEntry internalEntry) {
            this.internalEntry = internalEntry;
        }

        @Override
        public double getValue() {
            return this.internalEntry.get();
        }

        @Override
        public void setValue(double value) {
            this.internalEntry.set(value);
        }

        @Override
        public int getIndex() {
            return this.internalEntry.index();
        }

        @Override
        public void setIndex(int index) {
            throw new UnsupportedOperationException("setIndex not supported on iterator VectorEntry.");
        }
    }

    private final class AbstractMTJVectorIterator
    extends AbstractCloneableSerializable
    implements Iterator<VectorEntry> {
        private static final long serialVersionUID = 1L;
        private final Iterator<no.uib.cipr.matrix.VectorEntry> internalIterator;
        private final AbstractMTJVectorEntry entry;

        public AbstractMTJVectorIterator() {
            this.internalIterator = AbstractMTJVector.this.internalVector.iterator();
            this.entry = new AbstractMTJVectorEntry(null);
        }

        @Override
        public boolean hasNext() {
            return this.internalIterator.hasNext();
        }

        @Override
        public VectorEntry next() {
            this.entry.internalEntry = this.internalIterator.next();
            return this.entry;
        }

        @Override
        public void remove() {
            this.internalIterator.remove();
        }
    }
}

