/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.OperationNotConvergedException;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseVector;
import java.text.NumberFormat;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.sparse.QMR;

public abstract class AbstractSparseMatrix
extends AbstractMTJMatrix {
    private static final long serialVersionUID = 1L;

    protected AbstractSparseMatrix(Matrix internalMatrix) {
        super(internalMatrix);
    }

    public abstract void compact();

    @Override
    public SparseVector times(AbstractMTJVector vector) {
        SparseVector answer = new SparseVector(this.getNumRows());
        this.timesInto(vector, answer);
        return answer;
    }

    @Override
    public void setElement(int rowIndex, int columnIndex, double value) {
        double existing = this.getElement(rowIndex, columnIndex);
        if (existing != value) {
            super.setElement(rowIndex, columnIndex, value);
        }
    }

    @Override
    public SparseVector solve(AbstractMTJVector b) {
        SparseVector x;
        AbstractMTJVector bsquare;
        AbstractSparseMatrix Asquare;
        int M = this.getNumRows();
        int N = this.getNumColumns();
        int S = Math.max(M, N);
        if (M != N) {
            Asquare = new SparseMatrix(S, S);
            Asquare.setSubMatrix(0, 0, this);
        } else {
            Asquare = this;
        }
        if (S != M) {
            bsquare = new SparseVector(S);
            int i = 0;
            while (i < M) {
                bsquare.setElement(i, b.getElement(i));
                ++i;
            }
        } else {
            bsquare = b;
        }
        SparseVector xsquare = new SparseVector(Asquare.getNumColumns());
        QMR sparseSolver = new QMR(xsquare.getInternalVector());
        try {
            sparseSolver.solve(Asquare.getInternalMatrix(), bsquare.getInternalVector(), xsquare.getInternalVector());
        }
        catch (Exception ex) {
            throw new OperationNotConvergedException(ex);
        }
        if (S != N) {
            x = new SparseVector(N);
            int i = 0;
            while (i < N) {
                x.setElement(i, xsquare.getElement(i));
                ++i;
            }
        } else {
            x = xsquare;
        }
        return x;
    }

    @Override
    public DenseMatrix pseudoInverse(double effectiveZero) {
        DenseMatrix Ainternal = new DenseMatrix(this);
        return Ainternal.pseudoInverse(effectiveZero);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(100);
        int currRow = -1;
        for (MatrixEntry e : this) {
            if (e.getRowIndex() > currRow) {
                result.append(currRow == -1 ? "" : "\n");
                result.append("(");
                ++currRow;
            } else {
                result.append(" (");
            }
            result.append(e.getRowIndex());
            result.append(",");
            result.append(e.getColumnIndex());
            result.append("):");
            result.append(e.getValue());
        }
        if (result.length() == 0) {
            result.append("No nonzero entries");
        }
        return result.toString();
    }

    @Override
    public String toString(NumberFormat format) {
        StringBuilder result = new StringBuilder();
        for (MatrixEntry e : this) {
            result.append("(");
            result.append(e.getRowIndex());
            result.append(",");
            result.append(e.getColumnIndex());
            result.append("): ");
            result.append(format.format(e.getValue()));
            result.append("\n");
        }
        if (result.length() == 0) {
            result.append("No nonzero entries");
        }
        return result.toString();
    }

    @Override
    public SparseVector getColumn(int columnIndex) {
        int M = this.getNumRows();
        SparseVector columnVector = new SparseVector(M);
        int i = 0;
        while (i < M) {
            double value = this.getElement(i, columnIndex);
            if (value != 0.0) {
                columnVector.setElement(i, value);
            }
            ++i;
        }
        return columnVector;
    }

    @Override
    public SparseVector getRow(int rowIndex) {
        int N = this.getNumColumns();
        SparseVector rowVector = new SparseVector(N);
        int j = 0;
        while (j < N) {
            double value = this.getElement(rowIndex, j);
            if (value != 0.0) {
                rowVector.setElement(j, value);
            }
            ++j;
        }
        return rowVector;
    }

    @Override
    public boolean isSparse() {
        return true;
    }
}

