/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.MathUtil;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import gov.sandia.cognition.math.matrix.mtj.decomposition.SingularValueDecompositionMTJ;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;

public class DenseMatrix
extends AbstractMTJMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected DenseMatrix(int numRows, int numColumns) {
        super(new Object(){

            no.uib.cipr.matrix.DenseMatrix checkedCreateMatrix(int numRows, int numColumns) {
                MathUtil.checkedMultiply(numRows, numColumns);
                return new no.uib.cipr.matrix.DenseMatrix(numRows, numColumns);
            }
        }.checkedCreateMatrix(numRows, numColumns));
    }

    protected DenseMatrix(no.uib.cipr.matrix.DenseMatrix internalMatrix) {
        super(internalMatrix);
    }

    protected DenseMatrix(Matrix matrix) {
        this(matrix.getNumRows(), matrix.getNumColumns());
        for (MatrixEntry e : matrix) {
            this.setElement(e.getRowIndex(), e.getColumnIndex(), e.getValue());
        }
    }

    protected DenseMatrix(DenseMatrix matrix) {
        this(new no.uib.cipr.matrix.DenseMatrix((no.uib.cipr.matrix.DenseMatrix)matrix.getInternalMatrix().copy()));
    }

    @Override
    public DenseMatrix clone() {
        return (DenseMatrix)super.clone();
    }

    @Override
    public DenseMatrix times(AbstractMTJMatrix matrix) {
        int returnRows = this.getNumRows();
        int returnColumns = matrix.getNumColumns();
        DenseMatrix retval = new DenseMatrix(returnRows, returnColumns);
        this.timesInto(matrix, retval);
        return retval;
    }

    @Override
    public DenseVector times(AbstractMTJVector vector) {
        DenseVector answer = new DenseVector(this.getNumRows());
        this.timesInto(vector, answer);
        return answer;
    }

    protected void solveInto(DenseMatrix B, DenseMatrix X) {
        this.getInternalMatrix().solve(B.getInternalMatrix(), X.getInternalMatrix());
    }

    protected void solveInto(DenseVector b, DenseVector x) {
        this.getInternalMatrix().solve(b.getInternalVector(), x.getInternalVector());
    }

    @Override
    public DenseMatrix pseudoInverse(double effectiveZero) {
        SingularValueDecompositionMTJ svd = SingularValueDecompositionMTJ.create(this);
        return (DenseMatrix)svd.pseudoInverse(effectiveZero);
    }

    @Override
    public DenseMatrix getSubMatrix(int minRow, int maxRow, int minColumn, int maxColumn) {
        int numRows = maxRow - minRow + 1;
        if (numRows <= 0) {
            throw new IllegalArgumentException("minRow " + minRow + " >= maxRow " + maxRow);
        }
        int numColumns = maxColumn - minColumn + 1;
        if (numColumns <= 0) {
            throw new IllegalArgumentException("minCol " + minColumn + " >= maxCol " + maxColumn);
        }
        DenseMatrix submatrix = new DenseMatrix(numRows, numColumns);
        this.getSubMatrixInto(minRow, maxRow, minColumn, maxColumn, submatrix);
        return submatrix;
    }

    @Override
    public DenseMatrix transpose() {
        DenseMatrix retval = new DenseMatrix(this.getNumColumns(), this.getNumRows());
        this.transposeInto(retval);
        return retval;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(MathUtil.checkedMultiply(10, MathUtil.checkedMultiply(this.getNumRows(), this.getNumColumns())));
        int i = 0;
        while (i < this.getNumRows()) {
            int j = 0;
            while (j < this.getNumColumns()) {
                result.append(" ");
                result.append(this.getElement(i, j));
                ++j;
            }
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    @Override
    public String toString(NumberFormat format) {
        StringBuilder result = new StringBuilder(MathUtil.checkedMultiply(5, MathUtil.checkedMultiply(this.getNumRows(), this.getNumColumns())));
        int i = 0;
        while (i < this.getNumRows()) {
            int j = 0;
            while (j < this.getNumColumns()) {
                result.append(" ");
                result.append(format.format(this.getElement(i, j)));
                ++j;
            }
            result.append("\n");
            ++i;
        }
        return result.toString();
    }

    @Override
    public DenseVector getColumn(int columnIndex) {
        int M = this.getNumRows();
        DenseVector columnVector = new DenseVector(M);
        this.getColumnInto(columnIndex, columnVector);
        return columnVector;
    }

    @Override
    public DenseVector getRow(int rowIndex) {
        int N = this.getNumColumns();
        DenseVector rowVector = new DenseVector(N);
        this.getRowInto(rowIndex, rowVector);
        return rowVector;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int numRows = this.getNumRows();
        int numColumns = this.getNumColumns();
        double[][] data = new double[numRows][numColumns];
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numColumns) {
                data[i][j] = this.getElement(i, j);
                ++j;
            }
            ++i;
        }
        out.writeObject(data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double[][] data = (double[][])in.readObject();
        this.setInternalMatrix(new no.uib.cipr.matrix.DenseMatrix(data));
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public int getEntryCount() {
        return this.getNumRows() * this.getNumColumns();
    }

    protected double[] getArray() {
        return ((no.uib.cipr.matrix.DenseMatrix)this.getInternalMatrix()).getData();
    }

    @Override
    public DenseVector convertToVector() {
        return new DenseVector(this.getArray());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (parameters instanceof DenseVector) {
            this.convertFromVector((DenseVector)parameters);
        } else {
            super.convertFromVector(parameters);
        }
    }

    public void convertFromVector(DenseVector parameters) {
        double[] vectorParameters;
        double[] myParameters = this.getArray();
        if (myParameters.length != (vectorParameters = parameters.getArray()).length) {
            throw new IllegalArgumentException("Dimensions do not match");
        }
        int i = 0;
        while (i < myParameters.length) {
            myParameters[i] = vectorParameters[i];
            ++i;
        }
    }
}

