/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DenseVector
extends AbstractMTJVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient double[] array;

    protected DenseVector(int numDimensions) {
        this(new no.uib.cipr.matrix.DenseVector(numDimensions));
        if (numDimensions < 0) {
            throw new IllegalArgumentException("Vector must have non-negative dimensionality");
        }
    }

    protected DenseVector(DenseVector vector) {
        this((no.uib.cipr.matrix.DenseVector)vector.getInternalVector().copy());
    }

    protected DenseVector(Vector vector) {
        this(vector.getDimensionality());
        for (VectorEntry e : vector) {
            this.set(e.getIndex(), e.getValue());
        }
    }

    protected DenseVector(AbstractMTJVector vector) {
        this(new no.uib.cipr.matrix.DenseVector(vector.getInternalVector()));
    }

    protected DenseVector(double ... values) {
        this(new no.uib.cipr.matrix.DenseVector(values));
    }

    protected DenseVector(no.uib.cipr.matrix.DenseVector internalVector) {
        super(internalVector);
        this.array = internalVector.getData();
    }

    @Override
    protected void setInternalVector(no.uib.cipr.matrix.Vector internalVector) {
        this.setInternalVector((no.uib.cipr.matrix.DenseVector)internalVector);
    }

    protected void setInternalVector(no.uib.cipr.matrix.DenseVector internalVector) {
        super.setInternalVector(internalVector);
        this.array = internalVector.getData();
    }

    @Override
    public double getElement(int index) {
        return this.array[index];
    }

    @Override
    public void setElement(int index, double value) {
        this.array[index] = value;
    }

    @Override
    public double get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, double value) {
        this.array[index] = value;
    }

    @Override
    public int getDimensionality() {
        return this.array.length;
    }

    @Override
    public boolean equals(Vector other, double effectiveZero) {
        if (!this.checkSameDimensionality(other)) {
            return false;
        }
        double[] values = this.getArray();
        int dimensionality = this.getDimensionality();
        int i = 0;
        while (i < dimensionality) {
            double difference = values[i] - other.getElement(i);
            if (Math.abs(difference) > effectiveZero) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public double euclideanDistanceSquared(Vector other) {
        this.assertSameDimensionality(other);
        double sumSquared = 0.0;
        double[] values = this.getArray();
        int M = this.getDimensionality();
        int i = 0;
        while (i < M) {
            double delta = values[i] - other.getElement(i);
            sumSquared += delta * delta;
            ++i;
        }
        return sumSquared;
    }

    @Override
    public DenseMatrix outerProduct(AbstractMTJVector other) {
        int M = this.getDimensionality();
        int N = other.getDimensionality();
        DenseMatrix retval = new DenseMatrix(M, N);
        double[] values = this.getArray();
        int i = 0;
        while (i < M) {
            int j = 0;
            while (j < N) {
                retval.setElement(i, j, values[i] * other.getElement(j));
                ++j;
            }
            ++i;
        }
        return retval;
    }

    @Override
    public DenseVector stack(Vector other) {
        int M1 = this.getDimensionality();
        int M2 = other.getDimensionality();
        DenseVector stacked = new DenseVector(M1 + M2);
        for (VectorEntry e : this) {
            stacked.setElement(e.getIndex(), e.getValue());
        }
        for (VectorEntry e : other) {
            stacked.setElement(M1 + e.getIndex(), e.getValue());
        }
        return stacked;
    }

    @Override
    public DenseVector subVector(int minIndex, int maxIndex) {
        int M = maxIndex - minIndex + 1;
        DenseVector retval = new DenseVector(M);
        double[] retvalValues = retval.getArray();
        double[] values = this.getArray();
        int i = 0;
        while (i < M) {
            retvalValues[i] = values[i + minIndex];
            ++i;
        }
        return retval;
    }

    @Override
    public void transformEquals(UnivariateScalarFunction function) {
        double[] values = this.getArray();
        int dimensionality = values.length;
        int i = 0;
        while (i < dimensionality) {
            values[i] = function.evaluate(values[i]);
            ++i;
        }
    }

    @Override
    public void transformEquals(Vector.IndexValueTransform function) {
        double[] values = this.getArray();
        int dimensionality = values.length;
        int i = 0;
        while (i < dimensionality) {
            values[i] = function.transform(i, values[i]);
            ++i;
        }
    }

    @Override
    public void transformNonZerosEquals(UnivariateScalarFunction function) {
        double[] values = this.getArray();
        int dimensionality = values.length;
        int i = 0;
        while (i < dimensionality) {
            double value = values[i];
            if (value != 0.0) {
                values[i] = function.evaluate(value);
            }
            ++i;
        }
    }

    @Override
    public void transformNonZerosEquals(Vector.IndexValueTransform function) {
        double[] values = this.getArray();
        int dimensionality = values.length;
        int i = 0;
        while (i < dimensionality) {
            double value = values[i];
            if (value != 0.0) {
                values[i] = function.transform(i, value);
            }
            ++i;
        }
    }

    @Override
    public void forEachElement(Vector.IndexValueConsumer consumer) {
        double[] values = this.getArray();
        int dimensionality = values.length;
        int i = 0;
        while (i < dimensionality) {
            consumer.consume(i, values[i]);
            ++i;
        }
    }

    @Override
    public void forEachEntry(Vector.IndexValueConsumer consumer) {
        this.forEachElement(consumer);
    }

    @Override
    public void forEachNonZero(Vector.IndexValueConsumer consumer) {
        double[] values = this.getArray();
        int dimensionality = values.length;
        int i = 0;
        while (i < dimensionality) {
            double value = values[i];
            if (value != 0.0) {
                consumer.consume(i, value);
            }
            ++i;
        }
    }

    public double[] getArray() {
        return this.array;
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    @Override
    public int getEntryCount() {
        return this.getDimensionality();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double[] data = (double[])in.readObject();
        boolean deepCopy = false;
        this.setInternalVector(new no.uib.cipr.matrix.DenseVector(data, deepCopy));
    }
}

