/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.mtj.DiagonalMatrixMTJ;
import java.util.Random;

public class DiagonalMatrixFactoryMTJ
extends MatrixFactory<DiagonalMatrixMTJ> {
    private static final long serialVersionUID = 1L;
    public static final DiagonalMatrixFactoryMTJ INSTANCE = new DiagonalMatrixFactoryMTJ();

    @Override
    public DiagonalMatrixMTJ copyMatrix(Matrix m) {
        int M = m.getNumRows();
        int N = m.getNumColumns();
        DiagonalMatrixMTJ retval = this.createMatrix(M, N);
        int i = 0;
        while (i < M) {
            int j = 0;
            while (j < N) {
                double v = m.getElement(i, j);
                if (i == j) {
                    retval.setElement(i, v);
                } else if (v != 0.0) {
                    throw new IllegalArgumentException("Off-diagonal elements must be zero!!");
                }
                ++j;
            }
            ++i;
        }
        return retval;
    }

    @Override
    public DiagonalMatrixMTJ createMatrix(int numRows, int numColumns) {
        if (numRows != numColumns) {
            throw new IllegalArgumentException("Matrix must be square and diagonal!");
        }
        return this.createMatrix(numRows);
    }

    public DiagonalMatrixMTJ createMatrix(int dim) {
        return new DiagonalMatrixMTJ(dim);
    }

    public DiagonalMatrixMTJ diagonalValues(double[] diagonal) {
        return new DiagonalMatrixMTJ(diagonal);
    }

    @Override
    public DiagonalMatrixMTJ createMatrix(int numRows, int numColumns, double initialValue) {
        DiagonalMatrixMTJ result = this.createMatrix(numRows, numColumns);
        if (initialValue != 0.0) {
            int i = 0;
            while (i < numRows) {
                result.setElement(i, i, initialValue);
                ++i;
            }
        }
        return result;
    }

    @Override
    public DiagonalMatrixMTJ createUniformRandom(int numRows, int numColumns, double min, double max, Random random) {
        if (numRows != numColumns) {
            throw new IllegalArgumentException("numRows != numColumns");
        }
        return this.createUniformRandom(numRows, min, max, random);
    }

    public DiagonalMatrixMTJ createUniformRandom(int dimensionality, double min, double max, Random random) {
        DiagonalMatrixMTJ m = this.createMatrix(dimensionality);
        int i = 0;
        while (i < dimensionality) {
            m.setElement(i, random.nextDouble() * (max - min) + min);
            ++i;
        }
        return m;
    }
}

