/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.ComplexNumber;
import gov.sandia.cognition.math.matrix.DiagonalMatrix;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJMatrix;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import gov.sandia.cognition.math.matrix.mtj.DenseVectorFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseVectorFactoryMTJ;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import no.uib.cipr.matrix.BandMatrix;

public class DiagonalMatrixMTJ
extends AbstractMTJMatrix
implements DiagonalMatrix {
    private static final long serialVersionUID = 1L;

    protected DiagonalMatrixMTJ(int dim) {
        super(new BandMatrix(dim, 0, 0));
    }

    protected DiagonalMatrixMTJ(DiagonalMatrixMTJ other) {
        super(other.getInternalMatrix().copy());
    }

    protected DiagonalMatrixMTJ(double[] diagonal) {
        this(diagonal.length);
        double[] actual = this.getDiagonal();
        System.arraycopy(diagonal, 0, actual, 0, diagonal.length);
    }

    @Override
    public int getDimensionality() {
        return this.getNumRows();
    }

    @Override
    public BandMatrix getInternalMatrix() {
        return (BandMatrix)super.getInternalMatrix();
    }

    @Override
    protected void setInternalMatrix(no.uib.cipr.matrix.Matrix internalMatrix) {
        super.setInternalMatrix((BandMatrix)internalMatrix);
    }

    @Override
    public AbstractMTJMatrix times(AbstractMTJMatrix matrix) {
        if (!this.checkMultiplicationDimensions(matrix)) {
            throw new IllegalArgumentException("Number of columns of this != number of rows of matrix");
        }
        int M = this.getNumRows();
        int N = matrix.getNumColumns();
        DenseMatrix retval = DenseMatrixFactoryMTJ.INSTANCE.createMatrix(M, N);
        double[] diagonal = this.getDiagonal();
        int i = 0;
        while (i < M) {
            double di = diagonal[i];
            if (di != 0.0) {
                int j = 0;
                while (j < N) {
                    double vij = matrix.getElement(i, j);
                    if (vij != 0.0) {
                        retval.setElement(i, j, di * vij);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return retval;
    }

    @Override
    public DiagonalMatrixMTJ times(DiagonalMatrix matrix) {
        DiagonalMatrixMTJ clone = (DiagonalMatrixMTJ)this.clone();
        clone.timesEquals(matrix);
        return clone;
    }

    @Override
    public void timesEquals(DiagonalMatrix matrix) {
        if (!this.checkSameDimensions(matrix)) {
            throw new IllegalArgumentException("Matrix must be the same size as this");
        }
        int M = this.getDimensionality();
        int i = 0;
        while (i < M) {
            double d1i = this.getElement(i);
            double d2j = matrix.getElement(i);
            double v = d1i * d2j;
            this.setElement(i, v);
            ++i;
        }
    }

    @Override
    public AbstractMTJVector times(AbstractMTJVector vector) {
        int M = this.getDimensionality();
        if (M != vector.getDimensionality()) {
            throw new IllegalArgumentException("Number of Columns != vector.getDimensionality()");
        }
        double[] diagonal = this.getDiagonal();
        double[] retval = new double[diagonal.length];
        int i = 0;
        while (i < M) {
            double v1;
            double v2 = diagonal[i];
            if (v2 != 0.0 && (v1 = vector.getElement(i)) != 0.0) {
                retval[i] = v1 * v2;
            }
            ++i;
        }
        return DenseVectorFactoryMTJ.INSTANCE.copyArray(retval);
    }

    @Override
    public DiagonalMatrixMTJ dotTimes(Matrix matrix) {
        DiagonalMatrixMTJ clone = (DiagonalMatrixMTJ)this.clone();
        clone.dotTimesEquals(matrix);
        return clone;
    }

    @Override
    public void dotTimesEquals(AbstractMTJMatrix matrix) {
        this.assertSameDimensions(matrix);
        int M = this.getDimensionality();
        double[] diagonal = this.getDiagonal();
        int i = 0;
        while (i < M) {
            int n = i;
            diagonal[n] = diagonal[n] * matrix.getElement(i, i);
            ++i;
        }
    }

    @Override
    public boolean isSquare() {
        return true;
    }

    @Override
    public boolean isSymmetric() {
        return true;
    }

    @Override
    public boolean isSymmetric(double effectiveZero) {
        return true;
    }

    @Override
    public ComplexNumber logDeterminant() {
        double logsum = 0.0;
        int sign = 1;
        double[] diagonal = this.getDiagonal();
        int i = 0;
        while (i < diagonal.length) {
            double eigenvalue = diagonal[i];
            if (eigenvalue < 0.0) {
                sign = -sign;
                logsum += Math.log(-eigenvalue);
            } else {
                logsum += Math.log(eigenvalue);
            }
            ++i;
        }
        return new ComplexNumber(logsum, sign < 0 ? Math.PI : 0.0);
    }

    @Override
    public double normFrobenius() {
        double[] diagonal = this.getDiagonal();
        double sum = 0.0;
        int i = 0;
        while (i < diagonal.length) {
            double v = diagonal[i];
            sum += v * v;
            ++i;
        }
        return Math.sqrt(sum);
    }

    @Override
    public int rank(double effectiveZero) {
        int rank = 0;
        double[] diagonal = this.getDiagonal();
        int M = diagonal.length;
        int i = 0;
        while (i < M) {
            if (Math.abs(diagonal[i]) > effectiveZero) {
                ++rank;
            }
            ++i;
        }
        return rank;
    }

    @Override
    public Vector solve(AbstractMTJVector b) {
        DiagonalMatrixMTJ pinvA = this.pseudoInverse();
        return pinvA.times(b);
    }

    @Override
    public Matrix solve(Matrix B) {
        DiagonalMatrixMTJ pinvA = this.pseudoInverse();
        return pinvA.times(B);
    }

    @Override
    public Vector solve(Vector b) {
        DiagonalMatrixMTJ pinvA = this.pseudoInverse();
        return pinvA.times(b);
    }

    @Override
    public SparseMatrix getSubMatrix(int minRow, int maxRow, int minColumn, int maxColumn) {
        int numRows = maxRow - minRow + 1;
        if (numRows <= 0) {
            throw new IllegalArgumentException("minRow " + minRow + " >= maxRow " + maxRow);
        }
        int numColumns = maxColumn - minColumn + 1;
        if (numColumns <= 0) {
            throw new IllegalArgumentException("minCol " + minColumn + " >= maxCol " + maxColumn);
        }
        SparseMatrix submatrix = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(numRows, numColumns);
        this.getSubMatrixInto(minRow, maxRow, minColumn, maxColumn, submatrix);
        return submatrix;
    }

    @Override
    public DiagonalMatrixMTJ transpose() {
        return this;
    }

    @Override
    public double[] getDiagonal() {
        return this.getInternalMatrix().getData();
    }

    @Override
    public DiagonalMatrixMTJ pseudoInverse() {
        return this.pseudoInverse(0.0);
    }

    @Override
    public DiagonalMatrixMTJ pseudoInverse(double effectiveZero) {
        double[] diagonal = this.getDiagonal();
        int M = diagonal.length;
        double[] retval = new double[M];
        int i = 0;
        while (i < M) {
            double di = diagonal[i];
            retval[i] = Math.abs(di) <= effectiveZero ? 0.0 : 1.0 / di;
            ++i;
        }
        return new DiagonalMatrixMTJ(retval);
    }

    @Override
    public DiagonalMatrixMTJ inverse() {
        return this.pseudoInverse();
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    @Override
    public int getEntryCount() {
        return this.getInternalMatrix().getData().length;
    }

    @Override
    public Vector getColumn(int columnIndex) {
        int M = this.getDimensionality();
        Object column = SparseVectorFactoryMTJ.getDefault().createVector(M);
        column.setElement(columnIndex, this.getElement(columnIndex, columnIndex));
        return column;
    }

    @Override
    public Vector getRow(int rowIndex) {
        int N = this.getDimensionality();
        Object row = SparseVectorFactoryMTJ.getDefault().createVector(N);
        row.setElement(rowIndex, this.getElement(rowIndex, rowIndex));
        return row;
    }

    @Override
    public double getElement(int rowIndex, int columnIndex) {
        if (rowIndex != columnIndex) {
            return 0.0;
        }
        return this.getElement(rowIndex);
    }

    @Override
    public void setElement(int rowIndex, int columnIndex, double value) {
        if (rowIndex != columnIndex) {
            if (value != 0.0) {
                throw new IllegalArgumentException("Can only set diagonal elements in a DiagonalMatrix!");
            }
        } else {
            this.setElement(rowIndex, value);
        }
    }

    @Override
    public double getElement(int index) {
        double[] diagonal = this.getDiagonal();
        return diagonal[index];
    }

    @Override
    public void setElement(int index, double value) {
        double[] diagonal = this.getDiagonal();
        diagonal[index] = value;
    }

    @Override
    public DenseVector convertToVector() {
        return DenseVectorFactoryMTJ.INSTANCE.copyArray(this.getDiagonal());
    }

    @Override
    public void convertFromVector(Vector parameters) {
        if (this.getNumRows() != parameters.getDimensionality()) {
            throw new IllegalArgumentException("Wrong number of parameters!");
        }
        double[] diagonal = this.getDiagonal();
        int i = 0;
        while (i < diagonal.length) {
            diagonal[i] = parameters.getElement(i);
            ++i;
        }
    }

    @Override
    public String toString() {
        int M = this.getDimensionality();
        StringBuilder retval = new StringBuilder(M * 10);
        retval.append("(" + M + "x" + M + "), diagonal:");
        int i = 0;
        while (i < M) {
            retval.append(" " + this.getElement(i));
            ++i;
        }
        return retval.toString();
    }

    @Override
    public String toString(NumberFormat format) {
        int d = this.getDimensionality();
        StringBuilder result = new StringBuilder(d * 5);
        result.append("(" + d + "x" + d + "), diagonal:");
        int i = 0;
        while (i < d) {
            result.append(" " + format.format(this.getElement(i)));
            ++i;
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int numDiagonal = this.getDimensionality();
        double[] diag = new double[numDiagonal];
        int i = 0;
        while (i < numDiagonal) {
            diag[i] = this.getElement(i);
            ++i;
        }
        out.writeObject(diag);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        double[] diag = (double[])in.readObject();
        this.setInternalMatrix(new BandMatrix(diag.length, 0, 0));
        System.arraycopy(diag, 0, this.getDiagonal(), 0, diag.length);
    }
}

