/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.UnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorEntry;
import gov.sandia.cognition.math.matrix.mtj.AbstractMTJVector;
import gov.sandia.cognition.math.matrix.mtj.SparseRowMatrix;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SparseVector
extends AbstractMTJVector {
    private static final long serialVersionUID = 1L;

    protected SparseVector(int numDimensions) {
        this(numDimensions, 0);
    }

    protected SparseVector(int numDimensions, int initialNonZeros) {
        this(new no.uib.cipr.matrix.sparse.SparseVector(numDimensions, initialNonZeros));
    }

    protected SparseVector(no.uib.cipr.matrix.sparse.SparseVector internalVector) {
        super(internalVector);
    }

    protected SparseVector(Vector vector) {
        this(vector.getDimensionality());
        for (VectorEntry e : vector) {
            double value = e.getValue();
            if (value == 0.0) continue;
            this.setElement(e.getIndex(), value);
        }
    }

    @Override
    public int getEntryCount() {
        return this.getInternalVector().getUsed();
    }

    @Deprecated
    public int getNumElementsUsed() {
        return this.getInternalVector().getUsed();
    }

    @Override
    public void setElement(int index, double value) {
        double existing = this.getElement(index);
        if (existing != value) {
            super.setElement(index, value);
        }
    }

    @Override
    protected no.uib.cipr.matrix.sparse.SparseVector getInternalVector() {
        return (no.uib.cipr.matrix.sparse.SparseVector)super.getInternalVector();
    }

    @Override
    protected void setInternalVector(no.uib.cipr.matrix.Vector internalVector) {
        this.setInternalVector((no.uib.cipr.matrix.sparse.SparseVector)internalVector);
    }

    protected void setInternalVector(no.uib.cipr.matrix.sparse.SparseVector internalVector) {
        super.setInternalVector(internalVector);
    }

    @Override
    public double euclideanDistanceSquared(Vector other) {
        return this.minus(other).norm2Squared();
    }

    @Override
    public SparseRowMatrix outerProduct(AbstractMTJVector other) {
        int numRows = this.getDimensionality();
        int numColumns = other.getDimensionality();
        SparseRowMatrix result = new SparseRowMatrix(numRows, numColumns);
        for (VectorEntry e : this) {
            int i = e.getIndex();
            for (VectorEntry o : other) {
                int j = o.getIndex();
                result.setElement(i, j, e.getValue() * o.getValue());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        for (VectorEntry e : this) {
            result.append(i++ == 0 ? "(" : " (").append(String.valueOf(e.getIndex()) + "):" + e.getValue());
        }
        return result.toString();
    }

    public void compact() {
        this.getInternalVector().compact();
    }

    @Override
    public SparseVector stack(Vector other) {
        int d1 = this.getDimensionality();
        int d2 = other.getDimensionality();
        SparseVector stacked = new SparseVector(d1 + d2);
        for (VectorEntry e : this) {
            stacked.setElement(e.getIndex(), e.getValue());
        }
        for (VectorEntry e : other) {
            stacked.setElement(d1 + e.getIndex(), e.getValue());
        }
        return stacked;
    }

    @Override
    public void transformNonZerosEquals(UnivariateScalarFunction function) {
        no.uib.cipr.matrix.sparse.SparseVector internal = this.getInternalVector();
        double[] values = internal.getData();
        int used = internal.getUsed();
        int i = 0;
        while (i < used) {
            double value = values[i];
            if (value != 0.0) {
                values[i] = function.evaluate(value);
            }
            ++i;
        }
    }

    @Override
    public void transformNonZerosEquals(Vector.IndexValueTransform function) {
        no.uib.cipr.matrix.sparse.SparseVector internal = this.getInternalVector();
        int[] indices = internal.getRawIndex();
        double[] values = internal.getData();
        int used = internal.getUsed();
        int i = 0;
        while (i < used) {
            double value = values[i];
            if (value != 0.0) {
                values[i] = function.transform(indices[i], value);
            }
            ++i;
        }
    }

    @Override
    public void forEachElement(Vector.IndexValueConsumer consumer) {
        no.uib.cipr.matrix.sparse.SparseVector internal = this.getInternalVector();
        int[] indices = internal.getRawIndex();
        double[] values = internal.getData();
        int used = internal.getUsed();
        int dimensionality = internal.size();
        int i = 0;
        int index = 0;
        while (i < used && index < dimensionality) {
            double value;
            if (index < indices[i]) {
                value = 0.0;
            } else {
                value = values[i];
                ++i;
            }
            consumer.consume(index, value);
            ++index;
        }
        while (index < dimensionality) {
            consumer.consume(index, 0.0);
            ++index;
        }
    }

    @Override
    public void forEachEntry(Vector.IndexValueConsumer consumer) {
        no.uib.cipr.matrix.sparse.SparseVector internal = this.getInternalVector();
        int[] indices = internal.getRawIndex();
        double[] values = internal.getData();
        int used = internal.getUsed();
        int i = 0;
        while (i < used) {
            consumer.consume(indices[i], values[i]);
            ++i;
        }
    }

    @Override
    public void forEachNonZero(Vector.IndexValueConsumer consumer) {
        no.uib.cipr.matrix.sparse.SparseVector internal = this.getInternalVector();
        int[] indices = internal.getRawIndex();
        double[] values = internal.getData();
        int used = internal.getUsed();
        int i = 0;
        while (i < used) {
            double value = values[i];
            if (value != 0.0) {
                consumer.consume(indices[i], value);
            }
            ++i;
        }
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.compact();
        out.defaultWriteObject();
        int dimensionality = this.getDimensionality();
        int[] index = this.getInternalVector().getIndex();
        double[] data = this.getInternalVector().getData();
        out.writeObject(dimensionality);
        out.writeObject(index);
        out.writeObject(data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int dimensionality = (Integer)in.readObject();
        int[] index = (int[])in.readObject();
        double[] data = (double[])in.readObject();
        boolean deepCopy = false;
        this.setInternalVector(new no.uib.cipr.matrix.sparse.SparseVector(dimensionality, index, data, deepCopy));
        this.compact();
    }

    @Override
    public SparseVector subVector(int minIndex, int maxIndex) {
        int M = maxIndex - minIndex + 1;
        SparseVector subvector = new SparseVector(M);
        int i = 0;
        while (i < M) {
            double value = this.getElement(i + minIndex);
            if (value != 0.0) {
                subvector.setElement(i, value);
            }
            ++i;
        }
        return subvector;
    }
}

