/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.math.matrix.mtj;

import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vector3D;
import gov.sandia.cognition.math.matrix.mtj.DenseVector;
import java.util.Random;

public class Vector3
extends DenseVector
implements Vector3D {
    private static final long serialVersionUID = 1L;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double x, double y, double z) {
        super(3);
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public Vector3(Vector other) {
        this(other.getElement(0), other.getElement(1), other.getElement(2));
        this.assertSameDimensionality(other);
    }

    public Vector3(Vector3D other) {
        this(other.getX(), other.getY(), other.getZ());
    }

    @Override
    public Vector3 clone() {
        return (Vector3)super.clone();
    }

    @Override
    public int getDimensionality() {
        return 3;
    }

    @Override
    public double getX() {
        return this.getElement(0);
    }

    @Override
    public void setX(double x) {
        this.setElement(0, x);
    }

    @Override
    public double getY() {
        return this.getElement(1);
    }

    @Override
    public void setY(double y) {
        this.setElement(1, y);
    }

    @Override
    public double getZ() {
        return this.getElement(2);
    }

    @Override
    public void setZ(double z) {
        this.setElement(2, z);
    }

    @Override
    public void setXYZ(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    @Override
    public String toString() {
        return "<" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ">";
    }

    public static Vector3 createRandom(Random random) {
        return new Vector3(random.nextDouble(), random.nextDouble(), random.nextDouble());
    }

    @Override
    public Double getFirst() {
        return this.getX();
    }

    @Override
    public Double getSecond() {
        return this.getY();
    }

    @Override
    public Double getThird() {
        return this.getZ();
    }
}

