/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.util;

import gov.sandia.cognition.collection.DefaultComparator;
import java.io.Serializable;
import java.util.Arrays;

public class ArrayIndexSorter {
    public static int[] sortArrayAscending(double[] valuesToSort) {
        int M = valuesToSort.length;
        DoubleIntegerPair[] pairs = new DoubleIntegerPair[M];
        int i = 0;
        while (i < M) {
            pairs[i] = new DoubleIntegerPair(valuesToSort[i], i);
            ++i;
        }
        Arrays.sort(pairs, new DefaultComparator());
        int[] indices = new int[M];
        int i2 = 0;
        while (i2 < M) {
            indices[i2] = pairs[i2].getIndex();
            ++i2;
        }
        return indices;
    }

    public static int[] sortArrayDescending(double[] valuesToSort) {
        int M = valuesToSort.length;
        int[] ascendingIndices = ArrayIndexSorter.sortArrayAscending(valuesToSort);
        int[] descendingIndices = new int[M];
        int i = 0;
        while (i < M) {
            descendingIndices[i] = ascendingIndices[M - i - 1];
            ++i;
        }
        return descendingIndices;
    }

    private static class DoubleIntegerPair
    implements Comparable<DoubleIntegerPair>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private double value;
        private int index;

        DoubleIntegerPair(double value, int index) {
            this.setValue(value);
            this.setIndex(index);
        }

        @Override
        public int compareTo(DoubleIntegerPair o) {
            return Double.compare(this.getValue(), o.getValue());
        }

        public boolean equals(Object object) {
            return object instanceof DoubleIntegerPair && this.equals((DoubleIntegerPair)object);
        }

        public boolean equals(DoubleIntegerPair other) {
            return other != null && this.getIndex() == other.getIndex() && this.getValue() == other.getValue();
        }

        public int hashCode() {
            long doubleBits = Double.doubleToLongBits(this.value);
            return this.index + (int)(doubleBits ^ doubleBits >>> 32);
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

