/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.text.DecimalFormat;
import java.util.Arrays;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.Matrix;

abstract class AbstractDenseMatrix
extends AbstractMatrix {
    double[] data;

    public AbstractDenseMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        long size = (long)numRows * (long)numColumns;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Matrix of " + numRows + " x " + numColumns + " = " + size + " elements is too large to be allocated using a single Java array.");
        }
        this.data = new double[numRows * numColumns];
    }

    public AbstractDenseMatrix(Matrix A) {
        this(A, true);
    }

    public AbstractDenseMatrix(Matrix A, boolean deep) {
        super(A);
        if (deep) {
            this.data = new double[this.numRows * this.numColumns];
            this.copy(A);
        } else {
            this.data = ((AbstractDenseMatrix)A).getData();
        }
    }

    abstract void copy(Matrix var1);

    public double[] getData() {
        return this.data;
    }

    @Override
    public void add(int row, int column, double value) {
        int n = this.getIndex(row, column);
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void set(int row, int column, double value) {
        this.data[this.getIndex((int)row, (int)column)] = value;
    }

    @Override
    public double get(int row, int column) {
        return this.data[this.getIndex(row, column)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + column * this.numRows;
    }

    @Override
    public Matrix set(Matrix B) {
        if (!this.getClass().isAssignableFrom(B.getClass())) {
            return super.set(B);
        }
        this.checkSize(B);
        double[] Bd = ((AbstractDenseMatrix)B).getData();
        if (Bd == this.data) {
            return this;
        }
        System.arraycopy(Bd, 0, this.data, 0, this.data.length);
        return this;
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        DecimalFormat df = new DecimalFormat("####0.00");
        int i = 0;
        while (i < this.numRows()) {
            int j = 0;
            while (j < this.numColumns()) {
                double value = this.get(i, j);
                if (value >= 0.0) {
                    out.append(" ");
                }
                out.append(" " + df.format(value));
                ++j;
            }
            out.append("\n");
            ++i;
        }
        return out.toString();
    }
}

