/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import java.io.IOException;
import java.io.Serializable;
import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import org.netlib.util.intW;

public class DenseMatrix
extends AbstractDenseMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;

    public DenseMatrix(MatrixVectorReader r) throws IOException {
        block10: {
            int i;
            MatrixInfo info;
            block9: {
                super(0, 0);
                info = null;
                info = r.hasInfo() ? r.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                MatrixSize size = r.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                this.data = new double[this.numRows * this.numColumns];
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                if (info.isCoordinate()) {
                    int nz = size.numEntries();
                    int[] row = new int[nz];
                    int[] column = new int[nz];
                    double[] entry = new double[nz];
                    r.readCoordinate(row, column, entry);
                    r.add(-1, row);
                    r.add(-1, column);
                    int i2 = 0;
                    while (i2 < nz) {
                        this.set(row[i2], column[i2], entry[i2]);
                        ++i2;
                    }
                } else {
                    r.readArray(this.data);
                }
                if (!info.isSymmetric()) break block9;
                i = 0;
                while (i < this.numRows) {
                    int j = 0;
                    while (j < i) {
                        this.set(j, i, this.get(i, j));
                        ++j;
                    }
                    ++i;
                }
                break block10;
            }
            if (!info.isSkewSymmetric()) break block10;
            i = 0;
            while (i < this.numRows) {
                int j = 0;
                while (j < i) {
                    this.set(j, i, -this.get(i, j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public DenseMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public DenseMatrix(Matrix A) {
        super(A);
    }

    public DenseMatrix(Matrix A, boolean deep) {
        super(A, deep);
    }

    public DenseMatrix(Vector x, boolean deep) {
        super(x.size(), 1);
        if (deep) {
            for (VectorEntry e : x) {
                this.set(e.index(), 0, e.get());
            }
        } else {
            if (!(x instanceof DenseVector)) {
                throw new IllegalArgumentException("x must be a DenseVector");
            }
            this.data = ((DenseVector)x).getData();
        }
    }

    public DenseMatrix(Vector x) {
        this(x, true);
    }

    public DenseMatrix(Vector[] x) {
        super(x[0].size(), x.length);
        Vector[] vectorArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            Vector v = vectorArray[n2];
            if (v.size() != this.numRows) {
                throw new IllegalArgumentException("All vectors must be of the same size");
            }
            ++n2;
        }
        int j = 0;
        while (j < x.length) {
            for (VectorEntry e : x[j]) {
                this.set(e.index(), j, e.get());
            }
            ++j;
        }
    }

    public DenseMatrix(double[][] values) {
        super(values.length, values[0].length);
        int i = 0;
        while (i < values.length) {
            if (values[i].length != this.numColumns) {
                throw new IllegalArgumentException("Array cannot be jagged");
            }
            int j = 0;
            while (j < values[i].length) {
                this.set(i, j, values[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public DenseMatrix(int numRows, int numColumns, double[] values, boolean deep) {
        super(numRows, numColumns);
        if (numRows * numColumns != values.length) {
            throw new IllegalArgumentException("dimensions do not match");
        }
        this.data = deep ? (double[])values.clone() : values;
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this);
    }

    @Override
    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            this.set(e.row(), e.column(), e.get());
        }
    }

    public void addRow(double[] row) {
        if (row.length != this.numColumns) {
            throw new IllegalArgumentException("Attempt to add data with larger or smaller dimensions than this matrix.");
        }
        double[] newVec = new double[(this.numRows + 1) * this.numColumns];
        int initialRows = this.numRows;
        int targetRows = this.numRows + 1;
        int i = 0;
        while (i < initialRows + 1) {
            int j = 0;
            while (j < row.length) {
                newVec[i + j * targetRows] = i == initialRows ? row[j] : this.data[this.getIndex(i, j)];
                ++j;
            }
            ++i;
        }
        ++this.numRows;
        this.data = newVec;
    }

    public DenseVector delRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.numRows) {
            throw new IllegalArgumentException("Row: " + rowIndex + " does not exist in this matrix.");
        }
        DenseVector retVal = new DenseVector(this.numColumns);
        double[] newVec = new double[(this.numRows - 1) * this.numColumns];
        int targetRows = this.numRows - 1;
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                if (i == rowIndex) {
                    retVal.set(j, this.get(i, j));
                } else {
                    newVec[(i > rowIndex ? i - 1 : i) + j * targetRows] = this.data[this.getIndex(i, j)];
                }
                ++j;
            }
            ++i;
        }
        --this.numRows;
        this.data = newVec;
        return retVal;
    }

    public void addCol(double[] colData) {
        if (colData.length != this.numRows) {
            throw new IllegalArgumentException("Added column must contain the same number of rows as this matrix.");
        }
        double[] newVec = new double[this.numRows * (this.numColumns + 1)];
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns + 1) {
                newVec[i + j * this.numRows] = j == this.numColumns ? colData[i] : this.data[this.getIndex(i, j)];
                ++j;
            }
            ++i;
        }
        ++this.numColumns;
        this.data = newVec;
    }

    public void delCol(int colIndex) {
        if (colIndex < 0 || colIndex >= this.numColumns) {
            throw new IllegalArgumentException("col: " + colIndex + " does not exist in this matrix");
        }
        double[] newVec = new double[this.numRows * (this.numColumns - 1)];
        int i = 0;
        while (i < this.numRows) {
            int j = 0;
            while (j < this.numColumns) {
                if (j != colIndex) {
                    newVec[i + (j > colIndex ? j - 1 : j) * this.numRows] = this.data[this.getIndex(i, j)];
                }
                ++j;
            }
            ++i;
        }
        --this.numColumns;
        this.data = newVec;
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.multAdd(alpha, B, C);
        }
        this.checkMultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.NoTranspose.netlib(), Transpose.NoTranspose.netlib(), C.numRows(), C.numColumns(), this.numColumns, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transAmultAdd(alpha, B, C);
        }
        this.checkTransAmultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.Transpose.netlib(), Transpose.NoTranspose.netlib(), C.numRows(), C.numColumns(), this.numRows, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transBmultAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transBmultAdd(alpha, B, C);
        }
        this.checkTransBmultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.NoTranspose.netlib(), Transpose.Transpose.netlib(), C.numRows(), C.numColumns(), this.numColumns, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix transABmultAdd(double alpha, Matrix B, Matrix C) {
        if (!(B instanceof DenseMatrix) || !(C instanceof DenseMatrix)) {
            return super.transABmultAdd(alpha, B, C);
        }
        this.checkTransABmultAdd(B, C);
        double[] Bd = ((DenseMatrix)B).getData();
        double[] Cd = ((DenseMatrix)C).getData();
        BLAS.getInstance().dgemm(Transpose.Transpose.netlib(), Transpose.Transpose.netlib(), C.numRows(), C.numColumns(), this.numRows, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B.numRows()), 1.0, Cd, Math.max(1, C.numRows()));
        return C;
    }

    @Override
    public Matrix rank1(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank1(alpha, x, y);
        }
        this.checkRank1(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dger(this.numRows, this.numColumns, alpha, xd, 1, yd, 1, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgemv(Transpose.NoTranspose.netlib(), this.numRows, this.numColumns, alpha, this.data, Math.max(this.numRows, 1), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgemv(Transpose.Transpose.netlib(), this.numRows, this.numColumns, alpha, this.data, Math.max(this.numRows, 1), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        if (this.numRows != B.numRows()) {
            throw new IllegalArgumentException("numRows != B.numRows() (" + this.numRows + " != " + B.numRows() + ")");
        }
        if (this.numColumns != X.numRows()) {
            throw new IllegalArgumentException("numColumns != X.numRows() (" + this.numColumns + " != " + X.numRows() + ")");
        }
        if (X.numColumns() != B.numColumns()) {
            throw new IllegalArgumentException("X.numColumns() != B.numColumns() (" + X.numColumns() + " != " + B.numColumns() + ")");
        }
        if (this.isSquare()) {
            return this.LUsolve(B, X);
        }
        return this.QRsolve(B, X, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        if (this.numColumns != B.numRows()) {
            throw new IllegalArgumentException("numColumns != B.numRows() (" + this.numColumns + " != " + B.numRows() + ")");
        }
        if (this.numRows != X.numRows()) {
            throw new IllegalArgumentException("numRows != X.numRows() (" + this.numRows + " != " + X.numRows() + ")");
        }
        if (X.numColumns() != B.numColumns()) {
            throw new IllegalArgumentException("X.numColumns() != B.numColumns() (" + X.numColumns() + " != " + B.numColumns() + ")");
        }
        return this.QRsolve(B, X, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B, X);
        return x;
    }

    Matrix LUsolve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int[] piv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dgesv(this.numRows, B.numColumns(), (double[])this.data.clone(), Matrices.ld(this.numRows), piv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    Matrix QRsolve(Matrix B, Matrix X, Transpose trans) {
        int nrhs = B.numColumns();
        DenseMatrix Xtmp = new DenseMatrix(Math.max(this.numRows, this.numColumns), nrhs);
        int M = trans == Transpose.NoTranspose ? this.numRows : this.numColumns;
        int j = 0;
        while (j < nrhs) {
            int i = 0;
            while (i < M) {
                Xtmp.set(i, j, B.get(i, j));
                ++i;
            }
            ++j;
        }
        double[] newData = (double[])this.data.clone();
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgels(trans.netlib(), this.numRows, this.numColumns, nrhs, newData, Matrices.ld(this.numRows), Xtmp.getData(), Matrices.ld(this.numRows, this.numColumns), work, -1, info);
        int lwork = -1;
        lwork = info.val != 0 ? Math.max(1, Math.min(this.numRows, this.numColumns) + Math.max(Math.min(this.numRows, this.numColumns), nrhs)) : Math.max((int)work[0], 1);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dgels(trans.netlib(), this.numRows, this.numColumns, nrhs, newData, Matrices.ld(this.numRows), Xtmp.getData(), Matrices.ld(this.numRows, this.numColumns), work, lwork, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        int N = trans == Transpose.NoTranspose ? this.numColumns : this.numRows;
        int j2 = 0;
        while (j2 < nrhs) {
            int i = 0;
            while (i < N) {
                X.set(i, j2, Xtmp.get(i, j2));
                ++i;
            }
            ++j2;
        }
        return X;
    }
}

