/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.LAPACK;
import java.util.BitSet;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;

public class PermutationMatrix
extends AbstractMatrix {
    private int[] permutations;
    private int[] pivots;
    private boolean transposed;

    public static PermutationMatrix fromPartialPivots(int[] pivots) {
        int[] permutations = new int[pivots.length];
        int i = 0;
        while (i < pivots.length) {
            permutations[i] = i;
            ++i;
        }
        i = 0;
        while (i < pivots.length) {
            int j = pivots[i] - 1;
            if (j != i) {
                int tmp = permutations[i];
                permutations[i] = permutations[j];
                permutations[j] = tmp;
            }
            ++i;
        }
        return new PermutationMatrix(permutations, pivots);
    }

    public PermutationMatrix(int[] permutations) {
        this(permutations, null);
    }

    private PermutationMatrix(int[] permutations, int[] pivots) {
        super(permutations.length, permutations.length);
        this.permutations = permutations;
        BitSet bitset = new BitSet();
        int[] nArray = permutations;
        int n = permutations.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (bitset.get(i)) {
                throw new IllegalArgumentException("non-unique permutations: " + i);
            }
            bitset.set(i);
            ++n2;
        }
        this.pivots = pivots;
    }

    @Override
    public double get(int row, int column) {
        if (!this.transposed && this.permutations[row] == column) {
            return 1.0;
        }
        if (this.transposed && this.permutations[column] == row) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Matrix transpose() {
        this.transposed = !this.transposed;
        return this;
    }

    @Override
    public Matrix mult(Matrix B, Matrix C) {
        if (C instanceof DenseMatrix) {
            return this.mult(B, (DenseMatrix)C);
        }
        return super.mult(B, C);
    }

    public Matrix mult(Matrix B, DenseMatrix C) {
        if (this.pivots == null) {
            return super.mult(B, C);
        }
        this.checkMultAdd(B, C);
        C.set(B);
        LAPACK.getInstance().dlaswp(C.numColumns(), C.getData(), Matrices.ld(C.numRows()), 1, this.pivots.length, this.pivots, this.transposed ? -1 : 1);
        return C;
    }

    @Override
    public Matrix transAmult(Matrix B, Matrix C) {
        if (C instanceof DenseMatrix) {
            return this.transAmult(B, (DenseMatrix)C);
        }
        return super.transAmult(B, C);
    }

    public Matrix transAmult(Matrix B, DenseMatrix C) {
        if (this.pivots == null) {
            return super.transAmult(B, C);
        }
        this.checkTransAmultAdd(B, C);
        C.set(B);
        LAPACK.getInstance().dlaswp(C.numColumns(), C.getData(), Matrices.ld(C.numRows()), 1, this.pivots.length, this.pivots, this.transposed ? 1 : -1);
        return C;
    }
}

