/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.io;

public class MatrixInfo {
    private boolean sparse;
    private MatrixField field;
    private MatrixSymmetry symmetry;

    public MatrixInfo(boolean sparse, MatrixField field, MatrixSymmetry symmetry) {
        this.sparse = sparse;
        this.field = field;
        this.symmetry = symmetry;
        this.validate();
    }

    private void validate() {
        if (this.isDense() && this.isPattern()) {
            throw new IllegalArgumentException("Matrix cannot be dense with pattern storage");
        }
        if (this.isReal() && this.isHermitian()) {
            throw new IllegalArgumentException("Data cannot be real with hermitian symmetry");
        }
        if (!this.isComplex() && this.isHermitian()) {
            throw new IllegalArgumentException("Data must be complex with hermitian symmetry");
        }
        if (this.isPattern() && this.isSkewSymmetric()) {
            throw new IllegalArgumentException("Storage cannot be pattern and skew symmetrical");
        }
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public boolean isCoordinate() {
        return this.sparse;
    }

    public boolean isDense() {
        return !this.sparse;
    }

    public boolean isArray() {
        return !this.sparse;
    }

    public boolean isReal() {
        return this.field == MatrixField.Real;
    }

    public boolean isInteger() {
        return this.field == MatrixField.Integer;
    }

    public boolean isComplex() {
        return this.field == MatrixField.Complex;
    }

    public boolean isPattern() {
        return this.field == MatrixField.Pattern;
    }

    public boolean isGeneral() {
        return this.symmetry == MatrixSymmetry.General;
    }

    public boolean isSymmetric() {
        return this.symmetry == MatrixSymmetry.Symmetric;
    }

    public boolean isSkewSymmetric() {
        return this.symmetry == MatrixSymmetry.SkewSymmetric;
    }

    public boolean isHermitian() {
        return this.symmetry == MatrixSymmetry.Hermitian;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("%%MatrixMarket matrix ");
        if (this.isSparse()) {
            buf.append("coordinate ");
        } else {
            buf.append("array ");
        }
        if (this.isReal()) {
            buf.append("real ");
        } else if (this.isComplex()) {
            buf.append("complex ");
        } else if (this.isPattern()) {
            buf.append("pattern ");
        } else if (this.isInteger()) {
            buf.append("integer ");
        } else {
            throw new IllegalArgumentException("Unknown field specification");
        }
        if (this.isGeneral()) {
            buf.append("general\n");
        } else if (this.isSymmetric()) {
            buf.append("symmetric\n");
        } else if (this.isSkewSymmetric()) {
            buf.append("skew-symmetric\n");
        } else if (this.isHermitian()) {
            buf.append("Hermitian\n");
        } else {
            throw new IllegalArgumentException("Unknown symmetry specification");
        }
        return buf.toString();
    }

    public static enum MatrixField {
        Real,
        Integer,
        Complex,
        Pattern;

    }

    public static enum MatrixSymmetry {
        General,
        Symmetric,
        SkewSymmetric,
        Hermitian;

    }
}

