/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompColMatrix;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.SSOR;

public class AMG
implements Preconditioner {
    private SSOR[] preM;
    private SSOR[] postM;
    private int m;
    private CompRowMatrix[] A;
    private DenseLU lu;
    private DenseVector[] u;
    private DenseVector[] f;
    private DenseVector[] r;
    private CompColMatrix[] I;
    private final int min;
    private final int nu1;
    private final int nu2;
    private final int gamma;
    private final double omegaPreF;
    private final double omegaPreR;
    private final double omegaPostF;
    private final double omegaPostR;
    private final boolean reverse;
    private final double omega;
    private boolean transpose;

    public AMG(double omegaPreF, double omegaPreR, double omegaPostF, double omegaPostR, int nu1, int nu2, int gamma, int min, double omega) {
        this.omegaPreF = omegaPreF;
        this.omegaPreR = omegaPreR;
        this.omegaPostF = omegaPostF;
        this.omegaPostR = omegaPostR;
        this.reverse = true;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min;
        this.omega = omega;
    }

    public AMG(double omegaPre, double omegaPost, int nu1, int nu2, int gamma, int min, double omega) {
        this.omegaPreF = omegaPre;
        this.omegaPreR = omegaPre;
        this.omegaPostF = omegaPost;
        this.omegaPostR = omegaPost;
        this.reverse = false;
        this.nu1 = nu1;
        this.nu2 = nu2;
        this.gamma = gamma;
        this.min = min;
        this.omega = omega;
    }

    public AMG() {
        this(1.0, 1.85, 1.85, 1.0, 1, 1, 1, 40, 0.6666666666666666);
    }

    @Override
    public Vector apply(Vector b, Vector x) {
        this.u[0].set(x);
        this.f[0].set(b);
        this.transpose = false;
        this.cycle(0);
        return x.set(this.u[0]);
    }

    @Override
    public Vector transApply(Vector b, Vector x) {
        this.u[0].set(x);
        this.f[0].set(b);
        this.transpose = true;
        this.cycle(0);
        return x.set(this.u[0]);
    }

    @Override
    public void setMatrix(Matrix A) {
        LinkedList<CompRowMatrix> Al = new LinkedList<CompRowMatrix>();
        LinkedList<CompColMatrix> Il = new LinkedList<CompColMatrix>();
        Al.add(new CompRowMatrix(A));
        int k = 0;
        while (((CompRowMatrix)Al.get(k)).numRows() > this.min) {
            double eps;
            CompRowMatrix Af = (CompRowMatrix)Al.get(k);
            Aggregator aggregator = new Aggregator(Af, eps = 0.08 * Math.pow(0.5, k));
            if (aggregator.getAggregates().size() == 0) break;
            Interpolator sa = new Interpolator(aggregator, Af, this.omega);
            Al.add(sa.getGalerkinOperator());
            Il.add(sa.getInterpolationOperator());
            ++k;
        }
        this.m = Al.size();
        if (this.m == 0) {
            throw new RuntimeException("Matrix too small for AMG");
        }
        this.I = new CompColMatrix[this.m - 1];
        this.A = new CompRowMatrix[this.m - 1];
        Il.toArray(this.I);
        int i = 0;
        while (i < Al.size() - 1) {
            this.A[i] = (CompRowMatrix)Al.get(i);
            ++i;
        }
        DenseMatrix Ac = new DenseMatrix((Matrix)Al.get(Al.size() - 1));
        this.lu = new DenseLU(Ac.numRows(), Ac.numColumns());
        this.lu.factor(Ac);
        this.u = new DenseVector[this.m];
        this.f = new DenseVector[this.m];
        this.r = new DenseVector[this.m];
        int k2 = 0;
        while (k2 < this.m) {
            int n = ((CompRowMatrix)Al.get(k2)).numRows();
            this.u[k2] = new DenseVector(n);
            this.f[k2] = new DenseVector(n);
            this.r[k2] = new DenseVector(n);
            ++k2;
        }
        this.preM = new SSOR[this.m - 1];
        this.postM = new SSOR[this.m - 1];
        k2 = 0;
        while (k2 < this.m - 1) {
            CompRowMatrix Ak = this.A[k2];
            this.preM[k2] = new SSOR(Ak, this.reverse, this.omegaPreF, this.omegaPreR);
            this.postM[k2] = new SSOR(Ak, this.reverse, this.omegaPostF, this.omegaPostR);
            this.preM[k2].setMatrix(Ak);
            this.postM[k2].setMatrix(Ak);
            ++k2;
        }
    }

    private void cycle(int k) {
        if (k == this.m - 1) {
            this.directSolve();
        } else {
            this.preRelax(k);
            this.u[k + 1].zero();
            this.A[k].multAdd(-1.0, this.u[k], this.r[k].set(this.f[k]));
            this.I[k].transMult(this.r[k], this.f[k + 1]);
            int i = 0;
            while (i < this.gamma) {
                this.cycle(k + 1);
                ++i;
            }
            this.I[k].multAdd(this.u[k + 1], this.u[k]);
            this.postRelax(k);
        }
    }

    private void directSolve() {
        int k = this.m - 1;
        this.u[k].set(this.f[k]);
        DenseMatrix U = new DenseMatrix(this.u[k], false);
        if (this.transpose) {
            this.lu.transSolve(U);
        } else {
            this.lu.solve(U);
        }
    }

    private void preRelax(int k) {
        int i = 0;
        while (i < this.nu1) {
            if (this.transpose) {
                this.preM[k].transApply(this.f[k], this.u[k]);
            } else {
                this.preM[k].apply(this.f[k], this.u[k]);
            }
            ++i;
        }
    }

    private void postRelax(int k) {
        int i = 0;
        while (i < this.nu2) {
            if (this.transpose) {
                this.postM[k].transApply(this.f[k], this.u[k]);
            } else {
                this.postM[k].apply(this.f[k], this.u[k]);
            }
            ++i;
        }
    }

    private static class Aggregator {
        private List<Set<Integer>> C;
        private int[] diagind;
        private List<Set<Integer>> N;

        public Aggregator(CompRowMatrix A, double eps) {
            this.diagind = this.findDiagonalIndices(A);
            this.N = this.findNodeNeighborhood(A, this.diagind, eps);
            boolean[] R = this.createInitialR(A);
            this.C = this.createInitialAggregates(this.N, R);
            this.C = this.enlargeAggregates(this.C, this.N, R);
            this.C = this.createFinalAggregates(this.C, this.N, R);
        }

        public List<Set<Integer>> getAggregates() {
            return this.C;
        }

        public int[] getDiagonalIndices() {
            return this.diagind;
        }

        public List<Set<Integer>> getNodeNeighborhoods() {
            return this.N;
        }

        private int[] findDiagonalIndices(CompRowMatrix A) {
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            int[] diagind = new int[A.numRows()];
            int i = 0;
            while (i < A.numRows()) {
                diagind[i] = Arrays.binarySearch(colind, i, rowptr[i], rowptr[i + 1]);
                if (diagind[i] < 0) {
                    throw new RuntimeException("Matrix is missing a diagonal entry on row " + (i + 1));
                }
                ++i;
            }
            return diagind;
        }

        private List<Set<Integer>> findNodeNeighborhood(CompRowMatrix A, int[] diagind, double eps) {
            this.N = new ArrayList<Set<Integer>>(A.numRows());
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data = A.getData();
            int i = 0;
            while (i < A.numRows()) {
                HashSet<Integer> Ni = new HashSet<Integer>();
                double aii = data[diagind[i]];
                int j = rowptr[i];
                while (j < rowptr[i + 1]) {
                    double aij = data[j];
                    double ajj = data[diagind[colind[j]]];
                    if (Math.abs(aij) >= eps * Math.sqrt(aii * ajj)) {
                        Ni.add(colind[j]);
                    }
                    ++j;
                }
                this.N.add(Ni);
                ++i;
            }
            return this.N;
        }

        private boolean[] createInitialR(CompRowMatrix A) {
            boolean[] R = new boolean[A.numRows()];
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data = A.getData();
            int i = 0;
            while (i < A.numRows()) {
                boolean hasOffDiagonal = false;
                int j = rowptr[i];
                while (j < rowptr[i + 1]) {
                    if (colind[j] != i && data[j] != 0.0) {
                        hasOffDiagonal = true;
                        break;
                    }
                    ++j;
                }
                R[i] = hasOffDiagonal;
                ++i;
            }
            return R;
        }

        private List<Set<Integer>> createInitialAggregates(List<Set<Integer>> N, boolean[] R) {
            this.C = new ArrayList<Set<Integer>>();
            int i = 0;
            while (i < R.length) {
                if (R[i]) {
                    boolean free = true;
                    for (int j : N.get(i)) {
                        free &= R[j];
                    }
                    if (free) {
                        this.C.add(new HashSet(N.get(i)));
                        for (int j : N.get(i)) {
                            R[j] = false;
                        }
                    }
                }
                ++i;
            }
            return this.C;
        }

        private List<Set<Integer>> enlargeAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            ArrayList belong = new ArrayList(R.length);
            int i = 0;
            while (i < R.length) {
                belong.add(new ArrayList());
                ++i;
            }
            int k = 0;
            while (k < C.size()) {
                for (int j : C.get(k)) {
                    ((List)belong.get(j)).add(k);
                }
                ++k;
            }
            int[] intersect = new int[C.size()];
            int i2 = 0;
            while (i2 < R.length) {
                if (R[i2]) {
                    java.util.Arrays.fill(intersect, 0);
                    int largest = 0;
                    int maxValue = 0;
                    for (int j : N.get(i2)) {
                        Iterator iterator = ((List)belong.get(j)).iterator();
                        while (iterator.hasNext()) {
                            int k2;
                            int n = k2 = ((Integer)iterator.next()).intValue();
                            intersect[n] = intersect[n] + 1;
                            if (intersect[k2] <= maxValue) continue;
                            largest = k2;
                            maxValue = intersect[largest];
                        }
                    }
                    if (maxValue > 0) {
                        R[i2] = false;
                        C.get(largest).add(i2);
                    }
                }
                ++i2;
            }
            return C;
        }

        private List<Set<Integer>> createFinalAggregates(List<Set<Integer>> C, List<Set<Integer>> N, boolean[] R) {
            int i = 0;
            while (i < R.length) {
                if (R[i]) {
                    HashSet<Integer> Cn = new HashSet<Integer>();
                    for (int j : N.get(i)) {
                        if (!R[j]) continue;
                        R[j] = false;
                        Cn.add(j);
                    }
                    if (!Cn.isEmpty()) {
                        C.add(Cn);
                    }
                }
                ++i;
            }
            return C;
        }
    }

    private static class Interpolator {
        private CompRowMatrix Ac;
        private CompColMatrix I;

        public Interpolator(Aggregator aggregator, CompRowMatrix A, double omega) {
            List<Set<Integer>> C = aggregator.getAggregates();
            List<Set<Integer>> N = aggregator.getNodeNeighborhoods();
            int[] diagind = aggregator.getDiagonalIndices();
            int[] pt = this.createTentativeProlongation(C, A.numRows());
            if (omega != 0.0) {
                List<Map<Integer, Double>> P = this.createSmoothedProlongation(C, N, A, diagind, omega, pt);
                this.I = this.createInterpolationMatrix(P, A.numRows());
                this.Ac = this.createGalerkinSlow(this.I, A);
            } else {
                this.Ac = this.createGalerkinFast(A, pt, C.size());
                this.I = this.createInterpolationMatrix(pt, C.size());
            }
        }

        private int[] createTentativeProlongation(List<Set<Integer>> C, int n) {
            int[] pt = new int[n];
            java.util.Arrays.fill(pt, -1);
            int i = 0;
            while (i < C.size()) {
                for (int j : C.get(i)) {
                    pt[j] = i;
                }
                ++i;
            }
            return pt;
        }

        private CompRowMatrix createGalerkinFast(CompRowMatrix A, int[] pt, int c) {
            int n = pt.length;
            FlexCompRowMatrix Ac = new FlexCompRowMatrix(c, c);
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data = A.getData();
            int i = 0;
            while (i < n) {
                if (pt[i] != -1) {
                    int j = rowptr[i];
                    while (j < rowptr[i + 1]) {
                        if (pt[colind[j]] != -1) {
                            Ac.add(pt[i], pt[colind[j]], data[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return new CompRowMatrix(Ac);
        }

        private CompColMatrix createInterpolationMatrix(List<Map<Integer, Double>> P, int n) {
            Map<Integer, Double> Pj;
            int c = P.size();
            int[][] nz = new int[c][];
            int j = 0;
            while (j < c) {
                Pj = P.get(j);
                nz[j] = new int[Pj.size()];
                int l = 0;
                for (int k : Pj.keySet()) {
                    nz[j][l++] = k;
                }
                ++j;
            }
            this.I = new CompColMatrix(n, c, nz);
            j = 0;
            while (j < c) {
                Pj = P.get(j);
                for (Map.Entry<Integer, Double> e : Pj.entrySet()) {
                    this.I.set(e.getKey(), j, e.getValue());
                }
                ++j;
            }
            return this.I;
        }

        private CompColMatrix createInterpolationMatrix(int[] pt, int c) {
            FlexCompColMatrix If = new FlexCompColMatrix(pt.length, c);
            int i = 0;
            while (i < pt.length) {
                if (pt[i] != -1) {
                    If.set(i, pt[i], 1.0);
                }
                ++i;
            }
            return new CompColMatrix(If);
        }

        public CompColMatrix getInterpolationOperator() {
            return this.I;
        }

        private List<Map<Integer, Double>> createSmoothedProlongation(List<Set<Integer>> C, List<Set<Integer>> N, CompRowMatrix A, int[] diagind, double omega, int[] pt) {
            int n = A.numRows();
            int c = C.size();
            ArrayList<Map<Integer, Double>> P = new ArrayList<Map<Integer, Double>>(c);
            int i = 0;
            while (i < c) {
                P.add(new HashMap());
                ++i;
            }
            int[] rowptr = A.getRowPointers();
            int[] colind = A.getColumnIndices();
            double[] data = A.getData();
            double[] dot = new double[c];
            int i2 = 0;
            while (i2 < n) {
                if (pt[i2] != -1) {
                    java.util.Arrays.fill(dot, 0.0);
                    Set<Integer> Ni = N.get(i2);
                    double weakAij = 0.0;
                    int j = rowptr[i2];
                    while (j < rowptr[i2 + 1]) {
                        if (pt[colind[j]] != -1) {
                            double aij = data[j];
                            if (aij != 0.0 && !Ni.contains(colind[j])) {
                                weakAij += aij;
                            } else {
                                int n2 = pt[colind[j]];
                                dot[n2] = dot[n2] + aij;
                            }
                        }
                        ++j;
                    }
                    int n3 = pt[i2];
                    dot[n3] = dot[n3] - weakAij;
                    double scale = -omega / data[diagind[i2]];
                    int j2 = 0;
                    while (j2 < dot.length) {
                        int n4 = j2++;
                        dot[n4] = dot[n4] * scale;
                    }
                    int n5 = pt[i2];
                    dot[n5] = dot[n5] + 1.0;
                    j2 = 0;
                    while (j2 < dot.length) {
                        if (dot[j2] != 0.0) {
                            ((Map)P.get(j2)).put(i2, dot[j2]);
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
            return P;
        }

        private CompRowMatrix createGalerkinSlow(CompColMatrix I, CompRowMatrix A) {
            int n = I.numRows();
            int c = I.numColumns();
            FlexCompRowMatrix Ac = new FlexCompRowMatrix(c, c);
            double[] aiCol = new double[n];
            double[] iCol = new double[n];
            DenseVector aiV = new DenseVector(aiCol, false);
            DenseVector iV = new DenseVector(iCol, false);
            double[] itaiCol = new double[c];
            DenseVector itaiV = new DenseVector(itaiCol, false);
            int[] colptr = I.getColumnPointers();
            int[] rowind = I.getRowIndices();
            double[] Idata = I.getData();
            int k = 0;
            while (k < c) {
                iV.zero();
                int i = colptr[k];
                while (i < colptr[k + 1]) {
                    iCol[rowind[i]] = Idata[i];
                    ++i;
                }
                A.mult(iV, aiV);
                I.transMult(aiV, itaiV);
                i = 0;
                while (i < c) {
                    if (itaiCol[i] != 0.0) {
                        Ac.set(i, k, itaiCol[i]);
                    }
                    ++i;
                }
                ++k;
            }
            return new CompRowMatrix(Ac);
        }

        public CompRowMatrix getGalerkinOperator() {
            return this.Ac;
        }
    }
}

