/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.SparseVector;
import no.uib.cipr.matrix.sparse.SuperIterator;

public class FlexCompRowMatrix
extends AbstractMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    SparseVector[] rowD;

    public FlexCompRowMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.rowD = new SparseVector[numRows];
        int i = 0;
        while (i < numRows) {
            this.rowD[i] = new SparseVector(numColumns);
            ++i;
        }
    }

    public FlexCompRowMatrix(Matrix A, boolean deep) {
        super(A);
        this.rowD = new SparseVector[this.numRows];
        if (deep) {
            int i = 0;
            while (i < this.numRows) {
                this.rowD[i] = new SparseVector(this.numColumns);
                ++i;
            }
            this.set(A);
        } else {
            FlexCompRowMatrix Ar = (FlexCompRowMatrix)A;
            int i = 0;
            while (i < this.numRows) {
                this.rowD[i] = Ar.getRow(i);
                ++i;
            }
        }
    }

    public FlexCompRowMatrix(Matrix A) {
        this(A, true);
    }

    public void addRow(double[] data) {
        if (data.length != this.numColumns) {
            throw new IllegalArgumentException("Attempt to add data with larger or smaller dimensions than this matrix.");
        }
        ++this.numRows;
        SparseVector[] newVec = new SparseVector[this.numRows];
        System.arraycopy(this.rowD, 0, newVec, 0, this.rowD.length);
        newVec[this.numRows - 1] = new SparseVector(this.numColumns, IntStream.range(0, this.numColumns).toArray(), data);
        this.rowD = newVec;
        this.rowD[this.numRows - 1].compact();
    }

    public SparseVector delRow(int rowIndex) {
        SparseVector retVal = this.rowD[rowIndex];
        if (rowIndex != this.numRows - 1) {
            int i = rowIndex;
            while (i < this.numRows - 1) {
                this.rowD[i] = this.rowD[i + 1];
                ++i;
            }
        }
        SparseVector[] newVec = new SparseVector[this.numRows - 1];
        System.arraycopy(this.rowD, 0, newVec, 0, this.numRows - 1);
        --this.numRows;
        this.rowD = newVec;
        return retVal;
    }

    public void addCol(double[] colData) {
        if (colData.length != this.numRows) {
            throw new IllegalArgumentException("Added column must contain the same number of rows as this matrix.");
        }
        ++this.numColumns;
        int i = 0;
        while (i < this.rowD.length) {
            this.rowD[i] = (SparseVector)this.rowD[i].append(colData[i]);
            ++i;
        }
    }

    public void delCol(int colIndex) {
        if (colIndex >= this.numColumns) {
            throw new IllegalArgumentException("col: " + colIndex + " does not exist in this matrix");
        }
        --this.numColumns;
        int i = 0;
        while (i < this.rowD.length) {
            this.rowD[i] = (SparseVector)this.rowD[i].delete(colIndex);
            ++i;
        }
    }

    public SparseVector getRow(int i) {
        return this.rowD[i];
    }

    public void setRow(int i, SparseVector x) {
        if (x.size() != this.numColumns) {
            throw new IllegalArgumentException("New row must be of the same size as existing row");
        }
        this.rowD[i] = x;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        this.checkMultAdd(x, y);
        int i = 0;
        while (i < this.numRows) {
            y.add(i, alpha * this.rowD[i].dot(x));
            ++i;
        }
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        y.scale(1.0 / alpha);
        int i = 0;
        while (i < this.numRows) {
            SparseVector v = this.rowD[i];
            int[] index = v.getIndex();
            double[] data = v.getData();
            int length = v.getUsed();
            int j = 0;
            while (j < length) {
                int n = index[j];
                yd[n] = yd[n] + data[j] * xd[i];
                ++j;
            }
            ++i;
        }
        return y.scale(alpha);
    }

    @Override
    public void add(int row, int column, double value) {
        this.rowD[row].add(column, value);
    }

    @Override
    public void set(int row, int column, double value) {
        this.rowD[row].set(column, value);
    }

    @Override
    public double get(int row, int column) {
        return this.rowD[row].get(column);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new RowMatrixIterator();
    }

    @Override
    public Matrix copy() {
        return new FlexCompRowMatrix(this);
    }

    @Override
    public FlexCompRowMatrix zero() {
        int i = 0;
        while (i < this.numRows) {
            this.rowD[i].zero();
            ++i;
        }
        return this;
    }

    @Override
    public Matrix set(Matrix B) {
        if (!(B instanceof FlexCompRowMatrix)) {
            return super.set(B);
        }
        this.checkSize(B);
        FlexCompRowMatrix Bc = (FlexCompRowMatrix)B;
        int i = 0;
        while (i < this.numRows) {
            this.rowD[i].set(Bc.rowD[i]);
            ++i;
        }
        return this;
    }

    public void compact() {
        SparseVector[] sparseVectorArray = this.rowD;
        int n = this.rowD.length;
        int n2 = 0;
        while (n2 < n) {
            SparseVector v = sparseVectorArray[n2];
            v.compact();
            ++n2;
        }
    }

    private static class RowMatrixEntry
    implements MatrixEntry {
        private int row;
        private VectorEntry entry;

        private RowMatrixEntry() {
        }

        public void update(int row, VectorEntry entry) {
            this.row = row;
            this.entry = entry;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.entry.index();
        }

        @Override
        public double get() {
            return this.entry.get();
        }

        @Override
        public void set(double value) {
            this.entry.set(value);
        }
    }

    private class RowMatrixIterator
    implements Iterator<MatrixEntry> {
        private SuperIterator<SparseVector, VectorEntry> iterator;
        private RowMatrixEntry entry;

        private RowMatrixIterator() {
            this.iterator = new SuperIterator(Arrays.asList(FlexCompRowMatrix.this.rowD));
            this.entry = new RowMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatrixEntry next() {
            Object se = this.iterator.next();
            this.entry.update(((SuperIterator.SuperIteratorEntry)se).index(), (VectorEntry)((SuperIterator.SuperIteratorEntry)se).get());
            return this.entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

