/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.UpperCompRowMatrix;

public class ICC
implements Preconditioner {
    private final CompRowMatrix R;
    private Matrix Rt;
    private final Vector y;

    public ICC(CompRowMatrix R) {
        if (!R.isSquare()) {
            throw new IllegalArgumentException("ICC only applies to square matrices");
        }
        this.R = R;
        int n = R.numRows();
        this.y = new DenseVector(n);
    }

    @Override
    public Vector apply(Vector b, Vector x) {
        this.Rt.transSolve(b, this.y);
        return this.Rt.solve(this.y, x);
    }

    @Override
    public Vector transApply(Vector b, Vector x) {
        return this.apply(b, x);
    }

    @Override
    public void setMatrix(Matrix A) {
        this.R.set(A);
        this.factor();
    }

    private void factor() {
        int n = this.R.numRows();
        int[] colind = this.R.getColumnIndices();
        int[] rowptr = this.R.getRowPointers();
        double[] data = this.R.getData();
        double[] Rk = new double[n];
        int[] diagind = this.findDiagonalIndices(n, colind, rowptr);
        int k = 0;
        while (k < n) {
            java.util.Arrays.fill(Rk, 0.0);
            int i = rowptr[k];
            while (i < rowptr[k + 1]) {
                Rk[colind[i]] = data[i];
                ++i;
            }
            i = 0;
            while (i < k) {
                double Rii = data[diagind[i]];
                if (Rii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ICC process");
                }
                double Rki = Rk[i] / Rii;
                if (Rki != 0.0) {
                    int j = diagind[i] + 1;
                    while (j < rowptr[i + 1]) {
                        int n2 = colind[j];
                        Rk[n2] = Rk[n2] - Rki * data[j];
                        ++j;
                    }
                }
                ++i;
            }
            if (Rk[k] == 0.0) {
                throw new RuntimeException("Zero diagonal entry encountered on row " + (k + 1) + " during ICC process");
            }
            double sqRkk = Math.sqrt(Rk[k]);
            int i2 = diagind[k];
            while (i2 < rowptr[k + 1]) {
                data[i2] = Rk[colind[i2]] / sqRkk;
                ++i2;
            }
            ++k;
        }
        this.Rt = new UpperCompRowMatrix(this.R, diagind);
    }

    private int[] findDiagonalIndices(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        int k = 0;
        while (k < m) {
            diagind[k] = Arrays.binarySearch(colind, k, rowptr[k], rowptr[k + 1]);
            if (diagind[k] < 0) {
                throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
            }
            ++k;
        }
        return diagind;
    }
}

