/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.Quaqua14RootPaneUI;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.TextureColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

public class Quaqua14TitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener windowPropertyListener;
    private PropertyChangeListener rootPropertyListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private Quaqua14RootPaneUI rootPaneUI;
    private Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private Color inactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color inactiveShadow = new Color(0xB3B3B3);
    private Color activeBackground = null;
    private Color activeForeground = null;
    private Color activeShadow = null;
    private JComponent armer1;
    private JComponent armer2;

    public Quaqua14TitlePane(JRootPane root, Quaqua14RootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.rootPropertyListener = this.createRootPropertyChangeListener();
        this.rootPane.addPropertyChangeListener(this.rootPropertyListener);
        this.installSubcomponents();
        this.updateIconsAndTextures();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.windowPropertyListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.windowPropertyListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.windowPropertyListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new WindowPropertyHandler();
    }

    private PropertyChangeListener createRootPropertyChangeListener() {
        return new RootPropertyHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        this.createActions();
        this.createButtons();
        this.add(this.iconifyButton);
        this.add(this.toggleButton);
        this.add(this.closeButton);
    }

    private void installDefaults() {
    }

    private void uninstallDefaults() {
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    private JButton createTitleButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.iconifyButton = this.createTitleButton();
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconifyButton.setBorder(handyEmptyBorder);
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.toggleButton = this.createTitleButton();
        this.toggleButton.setAction(this.restoreAction);
        this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
        this.toggleButton.setBorder(handyEmptyBorder);
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        this.armer1 = new JPanel(null);
        this.armer1.setOpaque(false);
        this.armer2 = new JPanel(null);
        this.armer2.setOpaque(false);
        MouseAdapter buttonArmer = new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                Quaqua14TitlePane.this.closeButton.putClientProperty("paintRollover", Boolean.TRUE);
                Quaqua14TitlePane.this.iconifyButton.putClientProperty("paintRollover", Boolean.TRUE);
                Quaqua14TitlePane.this.toggleButton.putClientProperty("paintRollover", Boolean.TRUE);
                Quaqua14TitlePane.this.closeButton.repaint();
                Quaqua14TitlePane.this.iconifyButton.repaint();
                Quaqua14TitlePane.this.toggleButton.repaint();
            }

            public void mouseExited(MouseEvent e) {
                Quaqua14TitlePane.this.closeButton.putClientProperty("paintRollover", Boolean.FALSE);
                Quaqua14TitlePane.this.iconifyButton.putClientProperty("paintRollover", Boolean.FALSE);
                Quaqua14TitlePane.this.toggleButton.putClientProperty("paintRollover", Boolean.FALSE);
                Quaqua14TitlePane.this.closeButton.repaint();
                Quaqua14TitlePane.this.iconifyButton.repaint();
                Quaqua14TitlePane.this.toggleButton.repaint();
            }
        };
        this.closeButton.addMouseListener(buttonArmer);
        this.iconifyButton.addMouseListener(buttonArmer);
        this.toggleButton.addMouseListener(buttonArmer);
        this.armer1.addMouseListener(buttonArmer);
        this.armer2.addMouseListener(buttonArmer);
    }

    private void updateIconsAndTextures() {
        int size = this.getFont().getSize();
        boolean isVertical = this.isVertical();
        String prefix = size <= 9 ? "InternalFrame.mini." : (size <= 11 ? "InternalFrame.small." : "InternalFrame.");
        this.maximizeIcon = UIManager.getIcon(prefix + "maximizeIcon");
        this.minimizeIcon = UIManager.getIcon(prefix + "minimizeIcon");
        Icon closeIcon = UIManager.getIcon(prefix + "closeIcon");
        Icon iconifyIcon = UIManager.getIcon(prefix + "iconifyIcon");
        this.activeBackground = UIManager.getColor(prefix + (isVertical ? "vTitlePane.background" : "titlePane.background"));
        this.activeForeground = UIManager.getColor(prefix + "titlePane.foreground");
        this.activeShadow = UIManager.getColor(prefix + "titlePane.shadow");
        this.closeButton.setIcon(closeIcon);
        this.iconifyButton.setIcon(iconifyIcon);
        this.toggleButton.setIcon(this.maximizeIcon);
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        this.iconifyButton.putClientProperty("paintActive", activeB);
        this.closeButton.putClientProperty("paintActive", activeB);
        this.toggleButton.putClientProperty("paintActive", activeB);
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (this.state == state && !updateRegardless) {
            return;
        }
        boolean isPalette = (Boolean)this.rootPane.getClientProperty("Quaqua.RootPane.isPalette") == Boolean.TRUE;
        Frame frame = this.getFrame();
        if (frame != null && !isPalette) {
            JRootPane rootPane = this.getRootPane();
            if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                rootPane.setBorder(null);
            } else if ((state & 6) == 0) {
                this.rootPaneUI.installBorder(rootPane);
            }
            if (this.armer1.getParent() == null) {
                this.add(this.armer1);
            }
            if (this.armer2.getParent() == null) {
                this.add(this.armer2);
            }
            if (frame.isResizable()) {
                if ((state & 6) != 0) {
                    this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(true);
                } else {
                    this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                    this.maximizeAction.setEnabled(true);
                    this.restoreAction.setEnabled(false);
                }
                if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                    this.add(this.toggleButton);
                    this.add(this.iconifyButton);
                    this.revalidate();
                    this.repaint();
                }
                this.toggleButton.setText(null);
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                if (this.toggleButton.getParent() != null) {
                    this.remove(this.toggleButton);
                    this.revalidate();
                    this.repaint();
                }
            }
        } else {
            this.maximizeAction.setEnabled(false);
            this.restoreAction.setEnabled(false);
            this.iconifyAction.setEnabled(false);
            this.remove(this.armer1);
            this.remove(this.armer2);
            this.remove(this.toggleButton);
            this.remove(this.iconifyButton);
            this.revalidate();
            this.repaint();
        }
        this.closeAction.setEnabled(true);
        this.state = state;
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Dialog getDialog() {
        Window window = this.getWindow();
        if (window instanceof Dialog) {
            return (Dialog)window;
        }
        return null;
    }

    public Font getFont() {
        return this.rootPane.getFont();
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public void paintComponent(Graphics gr) {
        Color darkShadow;
        Color foreground;
        Color background;
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        Window window = this.getWindow();
        JRootPane rootPane = this.getRootPane();
        boolean isVertical = this.isVertical();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isPalette = (Boolean)rootPane.getClientProperty("Quaqua.RootPane.isPalette") == Boolean.TRUE;
        boolean isSelected = window == null ? false : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        if (isSelected |= isPalette) {
            background = this.activeBackground;
            foreground = this.activeForeground;
            darkShadow = this.activeShadow;
        } else {
            background = this.inactiveBackground;
            foreground = this.inactiveForeground;
            darkShadow = this.inactiveShadow;
        }
        g.setPaint(TextureColor.getPaint(background, window));
        g.fillRect(0, 0, width, height);
        g.setPaint(TextureColor.getPaint(darkShadow, window));
        if (isVertical) {
            g.drawLine(width - 1, 0, width - 1, height);
        } else {
            g.drawLine(0, height - 1, width, height - 1);
        }
        int xOffset = leftToRight ? 5 : width - 5;
        xOffset += leftToRight ? 21 : -21;
        String theTitle = this.getTitle();
        if (theTitle != null) {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics();
            g.setPaint(TextureColor.getPaint(foreground, window));
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            Rectangle toggleRect = new Rectangle(0, 0, 0, 0);
            if (this.toggleButton != null && this.toggleButton.getParent() != null) {
                toggleRect = this.toggleButton.getBounds();
            }
            Rectangle closeRect = new Rectangle(0, 0, 0, 0);
            if (this.closeButton != null && this.closeButton.getParent() != null) {
                closeRect = this.closeButton.getBounds();
            }
            if (isVertical) {
                int titleW = height - Math.max(toggleRect.y + toggleRect.height, closeRect.y + closeRect.height);
                theTitle = this.clippedText(theTitle, fm, titleW);
                xOffset = (width - fm.getHeight()) / 2 + fm.getAscent();
                int titleLength = SwingUtilities.computeStringWidth(fm, theTitle);
                AffineTransform at = g.getTransform();
                int y = Math.max(Math.max(closeRect.y + closeRect.height, toggleRect.y + toggleRect.height) + 5, (this.getHeight() - titleLength) / 2) + titleLength;
                g.rotate(-1.5707963705062866, xOffset, y);
                g.drawString(theTitle, xOffset, y);
                g.setTransform(at);
            } else {
                if (leftToRight) {
                    if (rect.x == 0) {
                        rect.x = window.getWidth() - window.getInsets().right - 2;
                    }
                    int titleW = this.getWidth() - Math.max(toggleRect.x + toggleRect.width, closeRect.x + closeRect.width) - 10;
                    theTitle = this.clippedText(theTitle, fm, titleW);
                } else {
                    int titleW = this.getWidth() - Math.max(toggleRect.x + toggleRect.width, closeRect.x + closeRect.width) - 10;
                    theTitle = this.clippedText(theTitle, fm, titleW);
                    xOffset -= SwingUtilities.computeStringWidth(fm, theTitle);
                }
                int titleLength = SwingUtilities.computeStringWidth(fm, theTitle);
                g.drawString(theTitle, Math.max(Math.max(closeRect.x + closeRect.width, toggleRect.x + toggleRect.width) + 5, (this.getWidth() - titleLength) / 2), yOffset);
                xOffset += leftToRight ? titleLength + 5 : -5;
            }
        }
        QuaquaUtilities.endGraphics(g, oldHints);
    }

    private String clippedText(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int nChars;
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            for (nChars = 0; nChars < text.length() && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; ++nChars) {
            }
            text = text.substring(0, nChars) + clipString;
        }
        return text;
    }

    private boolean isVertical() {
        return this.rootPane.getClientProperty("Quaqua.RootPane.isVertical") == Boolean.TRUE;
    }

    public void layoutVerticalContainer(Container c) {
        int spacing;
        int buttonWidth;
        int buttonHeight;
        int h = this.getHeight();
        int fontSize = this.getFont().getSize();
        int x = fontSize <= 9 ? 2 : (fontSize <= 11 ? 1 : 2);
        if (this.closeButton != null && this.closeButton.getIcon() != null) {
            buttonHeight = this.closeButton.getIcon().getIconHeight();
            buttonWidth = this.closeButton.getIcon().getIconWidth();
        } else {
            buttonHeight = 16;
            buttonWidth = 16;
        }
        int y = spacing = 5;
        if (this.menuBar != null) {
            this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
        }
        y = fontSize <= 9 ? 0 : (fontSize <= 11 ? 0 : 4);
        spacing = 2;
        y += spacing;
        if (this.closeButton != null) {
            this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
        }
        y += buttonHeight;
        if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
            spacing = 5;
            this.armer1.setBounds(x, y, buttonWidth, spacing);
            this.iconifyButton.setBounds(x, y += spacing, buttonWidth, buttonHeight);
            y += buttonHeight;
        } else {
            this.armer1.setBounds(0, 0, 0, 0);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            if (this.toggleButton.getParent() != null) {
                spacing = 5;
                this.armer2.setBounds(x, y, buttonWidth, spacing);
                this.toggleButton.setBounds(x, y += spacing, buttonWidth, buttonHeight);
                y += buttonHeight;
            }
        } else {
            this.armer2.setBounds(0, 0, 0, 0);
        }
        this.buttonsWidth = x + buttonWidth;
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            Quaqua14TitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            Quaqua14TitlePane.this.setActive(false);
        }
    }

    private class WindowPropertyHandler
    implements PropertyChangeListener {
        private WindowPropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = Quaqua14TitlePane.this.getFrame();
                if (frame != null) {
                    Quaqua14TitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    Quaqua14TitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                Quaqua14TitlePane.this.repaint();
            } else if ("Quaqua.RootPane.isVertical".equals(name)) {
                Quaqua14TitlePane.this.updateIconsAndTextures();
                Quaqua14TitlePane.this.revalidate();
                Quaqua14TitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                Quaqua14TitlePane.this.revalidate();
                Quaqua14TitlePane.this.repaint();
            }
        }
    }

    private class RootPropertyHandler
    implements PropertyChangeListener {
        private RootPropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("Quaqua.RootPane.isVertical".equals(name)) {
                Quaqua14TitlePane.this.updateIconsAndTextures();
                Quaqua14TitlePane.this.revalidate();
                Quaqua14TitlePane.this.repaint();
            } else if ("windowModified".equals(name)) {
                Quaqua14TitlePane.this.closeButton.setSelected((Boolean)pce.getNewValue());
            } else if ("font".equals(name)) {
                Quaqua14TitlePane.this.updateIconsAndTextures();
                Quaqua14TitlePane.this.revalidate();
                Quaqua14TitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            int fontSize = Quaqua14TitlePane.this.getFont().getSize();
            if (fontSize <= 9) {
                return 12;
            }
            if (fontSize <= 11) {
                return 16;
            }
            return 22;
        }

        public void layoutContainer(Container c) {
            JRootPane rootPane = Quaqua14TitlePane.this.getRootPane();
            boolean isVertical = Quaqua14TitlePane.this.isVertical();
            if (isVertical) {
                Quaqua14TitlePane.this.layoutVerticalContainer(c);
            } else {
                this.layoutHorizontalContainer(c);
            }
        }

        public void layoutHorizontalContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            int fontSize = Quaqua14TitlePane.this.getFont().getSize();
            boolean leftToRight = Quaqua14TitlePane.this.window == null ? !Quaqua14TitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : !Quaqua14TitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = Quaqua14TitlePane.this.getWidth();
            int y = fontSize <= 9 ? 1 : (fontSize <= 11 ? 1 : 4);
            if (Quaqua14TitlePane.this.closeButton != null && Quaqua14TitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = Quaqua14TitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = Quaqua14TitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (Quaqua14TitlePane.this.menuBar != null) {
                Quaqua14TitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = fontSize <= 11 ? 5 : 7;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (Quaqua14TitlePane.this.closeButton != null) {
                Quaqua14TitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (Quaqua14TitlePane.this.iconifyButton != null && Quaqua14TitlePane.this.iconifyButton.getParent() != null) {
                spacing = 5;
                Quaqua14TitlePane.this.armer1.setBounds(x, y, spacing, buttonHeight);
                Quaqua14TitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            } else {
                Quaqua14TitlePane.this.armer1.setBounds(0, 0, 0, 0);
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                if (Quaqua14TitlePane.this.toggleButton.getParent() != null) {
                    spacing = 5;
                    Quaqua14TitlePane.this.armer2.setBounds(x, y, spacing, buttonHeight);
                    Quaqua14TitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            } else {
                Quaqua14TitlePane.this.armer2.setBounds(0, 0, 0, 0);
            }
            Quaqua14TitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        public void paint(Graphics gr) {
            Image image;
            Graphics2D g = (Graphics2D)gr;
            Frame frame = Quaqua14TitlePane.this.getFrame();
            if (this.isOpaque()) {
                g.setPaint(TextureColor.getPaint(this.getBackground(), this));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                g.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"Quaqua14TitlePane.maximizeTitle", Quaqua14TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Quaqua14TitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"Quaqua14TitlePane.restoreTitle", Quaqua14TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Quaqua14TitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"Quaqua14TitlePane.iconifyTitle", Quaqua14TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Quaqua14TitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"Quaqua14TitlePane.closeTitle", Quaqua14TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Quaqua14TitlePane.this.close();
        }
    }
}

