/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.ButtonFocusIcon;
import ch.randelshofer.quaqua.ButtonStateIcon;
import ch.randelshofer.quaqua.FrameButtonStateIcon;
import ch.randelshofer.quaqua.OverlayIcon;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.SliderThumbIcon;
import ch.randelshofer.quaqua.VisuallyLayoutableIcon;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.Methods;
import ch.randelshofer.quaqua.util.ShiftedIcon;
import ch.randelshofer.quaqua.util.Worker;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;

public class QuaquaIconFactory {
    private static BufferedImage applicationImage;
    static /* synthetic */ Class class$ch$randelshofer$quaqua$QuaquaIconFactory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    private QuaquaIconFactory() {
    }

    public static URL getResource(String location) {
        URL url = (class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource(location);
        if (url == null) {
            throw new InternalError("image resource missing: " + location);
        }
        return url;
    }

    public static Image createImage(String location) {
        return QuaquaIconFactory.createImage(class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory, location);
    }

    public static Image createImage(Class baseClass, String location) {
        return Toolkit.getDefaultToolkit().createImage(baseClass.getResource(location));
    }

    public static Image createBufferedImage(String location) {
        return Images.toBufferedImage(QuaquaIconFactory.createImage(location));
    }

    public static Icon[] createIcons(String location, int count, boolean horizontal) {
        Icon[] icons = new Icon[count];
        BufferedImage[] images = Images.split(QuaquaIconFactory.createImage(location), count, horizontal);
        for (int i = 0; i < count; ++i) {
            icons[i] = new IconUIResource(new ImageIcon(images[i]));
        }
        return icons;
    }

    public static Icon createIcon(String location, int count, boolean horizontal, int index) {
        return QuaquaIconFactory.createIcons(location, count, horizontal)[index];
    }

    public static Icon createButtonStateIcon(String location, int states) {
        return new ButtonStateIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createButtonStateIcon(String location, int states, Point shift) {
        return new ShiftedIcon((Icon)new ButtonStateIcon(QuaquaIconFactory.createImage(location), states, true), shift);
    }

    public static Icon createButtonStateIcon(String location, int states, Rectangle shift) {
        return new ShiftedIcon((Icon)new ButtonStateIcon(QuaquaIconFactory.createImage(location), states, true), shift);
    }

    public static Icon createFrameButtonStateIcon(String location, int states) {
        return new FrameButtonStateIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createOverlaidButtonStateIcon(String location1, int states1, String location2, int states2, Rectangle layoutRect) {
        return new IconUIResource(new VisuallyLayoutableIcon(new OverlayIcon(QuaquaIconFactory.createButtonStateIcon(location1, states1), QuaquaIconFactory.createButtonFocusIcon(location2, states2)), layoutRect));
    }

    public static Icon createButtonFocusIcon(String location, int states) {
        return new ButtonFocusIcon(QuaquaIconFactory.createImage(location), states, true);
    }

    public static Icon createSliderThumbIcon(String location) {
        return new SliderThumbIcon(QuaquaIconFactory.createImage(location), 5, true);
    }

    public static Icon createIcon(Class baseClass, String location) {
        return new ImageIcon(QuaquaIconFactory.createImage(baseClass, location));
    }

    public static Icon createIcon(Class baseClass, String location, Point shift) {
        return new ShiftedIcon((Icon)new ImageIcon(QuaquaIconFactory.createImage(baseClass, location)), shift);
    }

    public static Icon createIcon(Class baseClass, String location, Rectangle shiftAndSize) {
        return new ShiftedIcon((Icon)new ImageIcon(QuaquaIconFactory.createImage(baseClass, location)), shiftAndSize);
    }

    public static Icon createOptionPaneIcon(int messageType) {
        return new LazyOptionPaneIcon(messageType);
    }

    private static ImageIcon createApplicationIcon() {
        BufferedImage image = QuaquaIconFactory.getApplicationIconImage();
        return new ImageIcon(image.getScaledInstance(64, 64, 4));
    }

    private static ImageIcon createWarningIcon() {
        return QuaquaIconFactory.composeOptionPaneIcon("images/OptionPane.warningIcon.png");
    }

    private static ImageIcon createErrorIcon() {
        return QuaquaIconFactory.composeOptionPaneIcon("images/OptionPane.errorIcon.png");
    }

    private static ImageIcon composeOptionPaneIcon(String resource) {
        BufferedImage result = new BufferedImage(64, 64, 2);
        Graphics2D g = result.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        BufferedImage warningImage = Images.toBufferedImage(Toolkit.getDefaultToolkit().createImage((class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource(resource)));
        g.drawImage(warningImage, 0, 0, 58, 58, null);
        BufferedImage appImage = QuaquaIconFactory.getApplicationIconImage();
        g.drawImage(appImage, 32, 32, 32, 32, null);
        g.dispose();
        return new ImageIcon(result);
    }

    public static BufferedImage getApplicationIconImage() {
        if (applicationImage == null) {
            applicationImage = QuaquaIconFactory.createApplicationIconImage();
        }
        return applicationImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createApplicationIconImage() {
        if (QuaquaManager.getProperty("java.version").startsWith("1.3")) {
            return Images.toBufferedImage(Toolkit.getDefaultToolkit().createImage((class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource("images/ApplicationIcon.png")));
        }
        Integer myPool = null;
        BufferedImage image = null;
        try {
            myPool = (Integer)Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "push");
            Object nsApplication = Methods.invokeStatic("com.apple.cocoa.application.NSApplication", "sharedApplication");
            Object applicationIconImage = Methods.invoke(nsApplication, "applicationIconImage");
            Object data = Methods.invoke(applicationIconImage, "TIFFRepresentation");
            int dataLength = Methods.invokeGetter(data, "length", -1);
            byte[] bytes = (byte[])Methods.invoke(data, "bytes", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(0), new Integer(dataLength)});
            Class<?> imageIOClazz = Class.forName("javax.imageio.ImageIO");
            Object imageInputStream = Methods.invokeStatic(imageIOClazz, "createImageInputStream", class$java$lang$Object == null ? (class$java$lang$Object = QuaquaIconFactory.class$("java.lang.Object")) : class$java$lang$Object, (Object)new ByteArrayInputStream(bytes));
            Object imageReader = ((Iterator)Methods.invokeStatic(imageIOClazz, "getImageReadersByFormatName", class$java$lang$String == null ? (class$java$lang$String = QuaquaIconFactory.class$("java.lang.String")) : class$java$lang$String, (Object)"tiff")).next();
            Methods.invoke(imageReader, "setInput", class$java$lang$Object == null ? (class$java$lang$Object = QuaquaIconFactory.class$("java.lang.Object")) : class$java$lang$Object, imageInputStream);
            image = (BufferedImage)Methods.invoke(imageReader, "read", 0);
        }
        catch (Exception e) {
            System.err.println("Warning " + (class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory) + " couldn't access Java for Cocoa. Please make sure that /System/Library/Java is in the class path.");
            BufferedImage bufferedImage = Images.toBufferedImage(Toolkit.getDefaultToolkit().createImage((class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory).getResource("images/ApplicationIcon.png")));
            return bufferedImage;
        }
        finally {
            if (myPool != null) {
                try {
                    Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "pop", Integer.TYPE, (Object)myPool);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        return image;
    }

    public static BufferedImage createFileIconImage(File file) {
        return QuaquaIconFactory.createFileIconImage(file, 128, 128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createFileIconImage(File file, int iconWidth, int iconHeight) {
        if (!file.exists() || QuaquaManager.getProperty("java.version").startsWith("1.3")) {
            return null;
        }
        Integer myPool = null;
        BufferedImage image = null;
        try {
            myPool = (Integer)Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "push");
            Object nsWorkspace = Methods.invokeStatic("com.apple.cocoa.application.NSWorkspace", "sharedWorkspace");
            Object fileIconImage = Methods.invoke(nsWorkspace, "iconForFile", file.getPath());
            Class<?> nsSize = Class.forName("com.apple.cocoa.foundation.NSSize");
            Object size = Methods.newInstance(nsSize, new Class[]{Float.TYPE, Float.TYPE}, new Object[]{new Float(iconWidth), new Float(iconHeight)});
            Methods.invoke(fileIconImage, "setSize", nsSize, size);
            Object data = Methods.invoke(fileIconImage, "TIFFRepresentation");
            int dataLength = Methods.invokeGetter(data, "length", -1);
            byte[] bytes = (byte[])Methods.invoke(data, "bytes", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(0), new Integer(dataLength)});
            Class<?> imageIOClazz = Class.forName("javax.imageio.ImageIO");
            Object imageInputStream = Methods.invokeStatic(imageIOClazz, "createImageInputStream", class$java$lang$Object == null ? (class$java$lang$Object = QuaquaIconFactory.class$("java.lang.Object")) : class$java$lang$Object, (Object)new ByteArrayInputStream(bytes));
            Object imageReader = ((Iterator)Methods.invokeStatic(imageIOClazz, "getImageReadersByFormatName", class$java$lang$String == null ? (class$java$lang$String = QuaquaIconFactory.class$("java.lang.String")) : class$java$lang$String, (Object)"tiff")).next();
            Methods.invoke(imageReader, "setInput", class$java$lang$Object == null ? (class$java$lang$Object = QuaquaIconFactory.class$("java.lang.Object")) : class$java$lang$Object, imageInputStream);
            image = (BufferedImage)Methods.invoke(imageReader, "read", 0);
        }
        catch (Exception e) {
            System.err.println("Warning " + (class$ch$randelshofer$quaqua$QuaquaIconFactory == null ? (class$ch$randelshofer$quaqua$QuaquaIconFactory = QuaquaIconFactory.class$("ch.randelshofer.quaqua.QuaquaIconFactory")) : class$ch$randelshofer$quaqua$QuaquaIconFactory) + " couldn't access Java for Cocoa. Please make sure that /System/Library/Java is in the class path.");
            e.printStackTrace();
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (myPool != null) {
                try {
                    Methods.invokeStatic("com.apple.cocoa.foundation.NSAutoreleasePool", "pop", Integer.TYPE, (Object)myPool);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        return image;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LazyOptionPaneIcon
    implements Icon {
        private ImageIcon realIcon;
        private int messageType;
        private Worker worker;

        public LazyOptionPaneIcon(int messageType) {
            this.messageType = messageType;
        }

        public int getIconHeight() {
            return 64;
        }

        public int getIconWidth() {
            return 64;
        }

        public void paintIcon(final Component c, Graphics g, int x, int y) {
            if (this.realIcon == null && this.worker == null) {
                this.worker = new Worker(){

                    public Object construct() {
                        switch (LazyOptionPaneIcon.this.messageType) {
                            case 2: {
                                return QuaquaIconFactory.createWarningIcon();
                            }
                            case 0: {
                                return QuaquaIconFactory.createErrorIcon();
                            }
                        }
                        return QuaquaIconFactory.createApplicationIcon();
                    }

                    public void finished(Object value) {
                        LazyOptionPaneIcon.this.realIcon = (ImageIcon)value;
                        LazyOptionPaneIcon.this.worker = null;
                        c.repaint();
                    }
                };
                this.worker.start();
            } else if (this.realIcon != null) {
                this.realIcon.paintIcon(c, g, x, y);
            }
        }
    }
}

