/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BackgroundBorder;
import ch.randelshofer.quaqua.Debug;
import ch.randelshofer.quaqua.QuaquaCaret;
import ch.randelshofer.quaqua.QuaquaEditorKit;
import ch.randelshofer.quaqua.QuaquaFocusHandler;
import ch.randelshofer.quaqua.QuaquaHighlighter;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Fonts;
import ch.randelshofer.quaqua.util.InsetsUtil;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.View;

public class QuaquaTextFieldUI
extends BasicTextFieldUI
implements VisuallyLayoutable {
    boolean oldDragState = false;
    private FocusListener focusListener;
    private MouseListener popupListener;
    static final EditorKit defaultKit = new QuaquaEditorKit();

    public static ComponentUI createUI(JComponent jcomponent) {
        return new QuaquaTextFieldUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(QuaquaManager.getBoolean(this.getPropertyPrefix() + ".opaque"));
    }

    protected void installDefaults() {
        if (!QuaquaUtilities.isHeadless()) {
            this.oldDragState = Methods.invokeGetter((Object)this.getComponent(), "getDragEnabled", true);
            Methods.invokeIfExists((Object)this.getComponent(), "setDragEnabled", true);
        }
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        if (QuaquaUtilities.isHeadless()) {
            Methods.invokeIfExists((Object)this.getComponent(), "setDragEnabled", this.oldDragState);
        }
        super.uninstallDefaults();
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.getComponent().addFocusListener(this.focusListener);
        }
        this.popupListener = this.createPopupListener();
        if (this.popupListener != null) {
            this.getComponent().addMouseListener(this.popupListener);
        }
        super.installListeners();
    }

    protected void uninstallListeners() {
        if (this.focusListener != null) {
            this.getComponent().removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.popupListener != null) {
            this.getComponent().removeMouseListener(this.popupListener);
            this.popupListener = null;
        }
        super.uninstallListeners();
    }

    protected FocusListener createFocusListener() {
        return new QuaquaFocusHandler();
    }

    protected MouseListener createPopupListener() {
        return (MouseListener)UIManager.get(this.getPropertyPrefix() + ".popupHandler");
    }

    public EditorKit getEditorKit(JTextComponent tc) {
        return defaultKit;
    }

    public Insets getVisualMargin(JTextComponent tc) {
        Insets margin = (Insets)tc.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return margin == null ? new Insets(0, 0, 0, 0) : (Insets)margin.clone();
    }

    protected void paintSafely(Graphics g) {
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        JTextComponent editor = this.getComponent();
        Border border = editor.getBorder();
        if (border != null && border instanceof BackgroundBorder) {
            Border bb = ((BackgroundBorder)border).getBackgroundBorder();
            bb.paintBorder(editor, g, 0, 0, editor.getWidth(), editor.getHeight());
        }
        super.paintSafely(g);
        QuaquaUtilities.endGraphics((Graphics2D)g, oldHints);
        Debug.paint(g, editor, this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String string = event.getPropertyName();
        if (string.equals("Frame.active")) {
            QuaquaUtilities.repaintBorder(this.getComponent());
        } else {
            super.propertyChange(event);
        }
    }

    protected Caret createCaret() {
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        QuaquaCaret caret = new QuaquaCaret(window, this.getComponent());
        return caret;
    }

    protected Highlighter createHighlighter() {
        return new QuaquaHighlighter();
    }

    protected Keymap createKeymap() {
        String nm = this.getKeymapName();
        Keymap map = JTextComponent.getKeymap(nm);
        if (map == null) {
            Keymap parent = JTextComponent.getKeymap("default");
            map = JTextComponent.addKeymap(nm, parent);
            String prefix = this.getPropertyPrefix();
            Object o = UIManager.get(prefix + ".keyBindings");
            if (o != null && o instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] bindings = (JTextComponent.KeyBinding[])o;
                JTextComponent.loadKeymap(map, bindings, this.getComponent().getActions());
            }
        }
        return map;
    }

    public int getBaseline(JComponent c, int width, int height) {
        JTextComponent textComponent = (JTextComponent)c;
        View rootView = textComponent.getUI().getRootView(textComponent);
        if (rootView.getViewCount() > 0) {
            Insets insets = textComponent.getInsets();
            int h = height - insets.top - insets.bottom;
            int y = insets.top;
            View fieldView = rootView.getView(0);
            int vspan = (int)fieldView.getPreferredSpan(1);
            if (height != vspan) {
                int slop = h - vspan;
                y += slop / 2;
            }
            FontMetrics fm = textComponent.getFontMetrics(textComponent.getFont());
            return y += fm.getAscent();
        }
        return -1;
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return bounds;
        }
        JTextComponent b = (JTextComponent)c;
        if (type == 1 && b.getBorder() != null) {
            Border border = b.getBorder();
            if (border instanceof UIResource) {
                InsetsUtil.subtractInto(this.getVisualMargin(b), bounds);
                --bounds.height;
            }
        } else {
            bounds = this.getVisibleEditorRect();
            FontMetrics fm = c.getFontMetrics(c.getFont());
            int baseline = this.getBaseline(b, width, height);
            Rectangle textBounds = Fonts.getPerceivedBounds(b.getText(), b.getFont(), c);
            if (bounds == null) {
                bounds = textBounds;
                bounds.y += baseline;
            } else {
                bounds.y = baseline + textBounds.y;
                bounds.height = textBounds.height;
            }
            ++bounds.x;
            bounds.width -= 2;
        }
        return bounds;
    }
}

