/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.BackgroundBorderUIResource;
import ch.randelshofer.quaqua.PaintableColor;
import ch.randelshofer.quaqua.QuaquaButtonBorder;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class QuaquaToolBarUI
extends BasicToolBarUI {
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    static String IS_DIVIDER_DRAWN = "Quaqua.ToolBar.isDividerDrawn";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private HashMap borderTable = new HashMap();
    private Hashtable rolloverTable = new Hashtable();

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaToolBarUI();
    }

    public void paint(Graphics gr, JComponent c) {
        Graphics2D g = (Graphics2D)gr;
        g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
        g.fillRect(0, 0, c.getWidth(), c.getHeight());
    }

    protected void installDefaults() {
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        super.installDefaults();
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    public void validate() {
                        this.putClientProperty("Quaqua.RootPane.isVertical", QuaquaToolBarUI.this.toolBar.getOrientation() == 1 ? Boolean.FALSE : Boolean.TRUE);
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setFont(UIManager.getFont("ToolBar.titleFont"));
                rootPane.putClientProperty("Quaqua.RootPane.isPalette", Boolean.TRUE);
                rootPane.setOpaque(true);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog((Frame)null, toolbar.getName(), false));
        try {
            Methods.invoke((Object)dialog, "setUndecorated", true);
            Methods.invoke((Object)dialog.getRootPane(), "setWindowDecorationStyle", 1);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        dialog.getRootPane().putClientProperty("JDialog.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("JFrame.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("Dialog.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("Frame.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("JWindow.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("Window.isPalette", Boolean.TRUE);
        return dialog;
    }

    protected Border createRolloverBorder() {
        return new BackgroundBorderUIResource(new QuaquaButtonBorder("toolBarRollover"));
    }

    protected Border createNonRolloverBorder() {
        return new BackgroundBorderUIResource(new QuaquaButtonBorder("toolBar"));
    }

    private Border createNonRolloverToggleBorder() {
        return new BackgroundBorderUIResource(new QuaquaButtonBorder("toolBar"));
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(rolloverBorder);
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(true);
        }
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                if (b instanceof JToggleButton) {
                    ((JToggleButton)b).setBorder(nonRolloverToggleBorder);
                } else {
                    b.setBorder(nonRolloverBorder);
                }
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(false);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.remove(b);
            b.setBorder(border);
            Boolean value = (Boolean)this.rolloverTable.remove(b);
            if (value != null) {
                b.setRolloverEnabled(value);
            }
        }
    }
}

